/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.utils.BaseCodeUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BarCodeUtils
extends BaseCodeUtils {
    private static Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            this.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            this.put(EncodeHintType.MARGIN, 0);
        }
    };

    public static BufferedImage getBarCode(String vaNumber, int height, float widthScale) {
        Code128Writer writer = new Code128Writer();
        int width = new Code128Writer().encode(vaNumber).length;
        BitMatrix bitMatrix = writer.encode(vaNumber, BarcodeFormat.CODE_128, width, height, hints);
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        image = BarCodeUtils.scale(image, widthScale * 2.0f);
        return image;
    }

    public static BufferedImage scale(BufferedImage image, float scale) {
        int width = (int)((float)image.getWidth() * scale);
        int height = image.getHeight();
        Image img = image.getScaledInstance(width, height, 1);
        BufferedImage imageOut = new BufferedImage(width, height, 1);
        Graphics2D graphics = imageOut.createGraphics();
        graphics.drawImage(img, 0, 0, null);
        graphics.dispose();
        return imageOut;
    }

    public static BufferedImage insertTopWords(BufferedImage image, String equipNo, String leftUpWords, String rightUpWords, String leftDownWords, String rightDownWords) {
        int widthPadding = 0;
        int heightUpPadding = 0;
        int enohPadding = 0;
        int heightDownPadding = 0;
        if (StringUtils.isNotBlank((CharSequence)leftUpWords) || StringUtils.isNotBlank((CharSequence)rightUpWords) || StringUtils.isNotBlank((CharSequence)leftDownWords) || StringUtils.isNotBlank((CharSequence)rightDownWords)) {
            widthPadding += 20;
        }
        if (StringUtils.isNotBlank((CharSequence)leftUpWords) || StringUtils.isNotBlank((CharSequence)rightUpWords)) {
            heightUpPadding += 30;
        }
        if (StringUtils.isNotBlank((CharSequence)equipNo)) {
            enohPadding += 20;
        }
        if (StringUtils.isNotBlank((CharSequence)leftDownWords) || StringUtils.isNotBlank((CharSequence)rightDownWords)) {
            heightDownPadding += 30;
        }
        int width = image.getWidth() + widthPadding;
        int height = image.getHeight() + heightUpPadding + enohPadding + heightDownPadding;
        if ((StringUtils.isNotBlank((CharSequence)leftDownWords) || StringUtils.isNotBlank((CharSequence)rightDownWords)) && StringUtils.isBlank((CharSequence)leftUpWords) && StringUtils.isBlank((CharSequence)rightUpWords)) {
            heightUpPadding += 10;
            height += 10;
        }
        if (StringUtils.isBlank((CharSequence)equipNo) && (StringUtils.isNotBlank((CharSequence)leftUpWords) || StringUtils.isNotBlank((CharSequence)rightUpWords)) && StringUtils.isBlank((CharSequence)leftDownWords) && StringUtils.isBlank((CharSequence)rightDownWords)) {
            height += 10;
        }
        BufferedImage outImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = outImage.createGraphics();
        BarCodeUtils.setGraphics2D(g2d);
        BarCodeUtils.setColorWhite(g2d, width, height);
        g2d.drawImage(image.getScaledInstance(image.getWidth(), image.getHeight(), 4), widthPadding / 2, heightUpPadding, null);
        Color color = new Color(0, 0, 0);
        g2d.setColor(color);
        g2d.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        if (StringUtils.isNotBlank((CharSequence)rightUpWords)) {
            int rightUpWordsWidth = width - g2d.getFontMetrics().stringWidth(leftUpWords);
            g2d.drawString(rightUpWords, rightUpWordsWidth - widthPadding / 2, heightUpPadding / 2 + 5);
        }
        if (StringUtils.isNotBlank((CharSequence)leftUpWords)) {
            g2d.drawString(leftUpWords, widthPadding / 2, heightUpPadding / 2 + 5);
        }
        if (StringUtils.isNotBlank((CharSequence)equipNo)) {
            String equipNoString = equipNo.replace("", " ").trim();
            int strWidth = g2d.getFontMetrics().stringWidth(equipNoString);
            int wordStartX = (width - strWidth) / 2;
            g2d.drawString(equipNoString, wordStartX, image.getHeight() + heightUpPadding + enohPadding / 2 + 8);
        }
        if (StringUtils.isNotBlank((CharSequence)rightDownWords)) {
            int rightDownWordsWidth = width - widthPadding / 2 - g2d.getFontMetrics().stringWidth(rightDownWords);
            g2d.drawString(rightDownWords, rightDownWordsWidth, image.getHeight() + heightUpPadding + enohPadding + heightDownPadding / 2 + 5);
        }
        if (StringUtils.isNotBlank((CharSequence)leftDownWords)) {
            g2d.drawString(leftDownWords, widthPadding / 2, image.getHeight() + heightUpPadding + enohPadding + heightDownPadding / 2 + 5);
        }
        g2d.dispose();
        outImage.flush();
        return outImage;
    }

    private static void setGraphics2D(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        BasicStroke s = new BasicStroke(1.0f, 1, 0);
        g2d.setStroke(s);
    }

    private static void setColorWhite(Graphics2D g2d, int width, int height) {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.BLACK);
    }

    private static void setDrawRect(Graphics2D g2d, int width, int height) {
        int padding = 5;
        g2d.setColor(Color.DARK_GRAY);
        g2d.drawRect(padding, padding, width - padding * 2, height - padding * 2);
    }

    private static void setDrawRectDottedLine(Graphics2D g2d, int width, int height) {
        int padding = 10;
        g2d.setColor(Color.BLUE);
        BasicStroke stroke = new BasicStroke(0.5f, 1, 1, 0.5f, new float[]{1.0f, 4.0f}, 0.5f);
        g2d.setStroke(stroke);
        g2d.drawRect(padding, padding, width - padding * 2, height - padding * 2);
    }
}

