/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis.plus;

import cn.aotcloud.mybatis.annotation.EncryptedColumn;
import cn.aotcloud.mybatis.annotation.EncryptedTable;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.update.Update;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class ColumnEncryptInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    protected Pattern PARAM_PAIRS_RE = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)\\}");

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        super.beforePrepare(sh, connection, transactionTimeout);
    }

    public void beforeGetBoundSql(StatementHandler sh) {
        super.beforeGetBoundSql(sh);
    }

    public void beforeQuery(Executor executor, MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (Objects.isNull(parameterObject)) {
            return;
        }
        if (!(parameterObject instanceof Map)) {
            return;
        }
        Map paramMap = (Map)parameterObject;
        Set set = paramMap.values().stream().collect(Collectors.toSet());
        for (Object param : set) {
            if (param instanceof AbstractWrapper || param instanceof String || !this.needToDecrypt(param.getClass())) continue;
            this.encryptEntity(param);
        }
    }

    public void beforeUpdate(Executor executor, MappedStatement mappedStatement, Object parameterObject) throws SQLException {
        Object param;
        if (Objects.isNull(parameterObject)) {
            return;
        }
        if (!(parameterObject instanceof Map)) {
            if (this.needToDecrypt(parameterObject.getClass())) {
                this.encryptEntity(parameterObject);
            }
            return;
        }
        Map paramMap = (Map)parameterObject;
        if (paramMap.containsKey("et") && null != (param = paramMap.get("et"))) {
            if (this.needToDecrypt(param.getClass())) {
                this.encryptEntity(param);
            }
            return;
        }
        if (paramMap.containsKey("entity") && null != (param = paramMap.get("entity"))) {
            if (this.needToDecrypt(param.getClass())) {
                this.encryptEntity(param);
            }
            return;
        }
        if (paramMap.containsKey("ew") && null != (param = paramMap.get("ew"))) {
            Class entityClass;
            if (param instanceof Update && param instanceof AbstractWrapper && this.needToDecrypt(entityClass = mappedStatement.getParameterMap().getType())) {
                this.encryptWrapper(entityClass, param);
            }
            return;
        }
    }

    private boolean needToDecrypt(Class<?> objectClass) {
        EncryptedTable sensitiveData = (EncryptedTable)AnnotationUtils.findAnnotation(objectClass, EncryptedTable.class);
        return Objects.nonNull(sensitiveData);
    }

    private void encryptEntity(Object parameter) {
        Field[] declaredFields;
        Class<?> resultClass = parameter.getClass();
        for (Field field : declaredFields = resultClass.getDeclaredFields()) {
            EncryptedColumn sensitiveField = field.getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = null;
            try {
                object = field.get(parameter);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (!(object instanceof String)) continue;
            String value = (String)object;
            try {
                field.set(parameter, this.encryptData(value));
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    private void encryptWrapper(Class<?> entityClass, Object ewParam) {
        Method[] declaredMethods;
        Object value;
        String valueKey;
        Matcher matcher;
        Field[] declaredFields;
        AbstractWrapper updateWrapper = (AbstractWrapper)ewParam;
        String sqlSet = updateWrapper.getSqlSet();
        if (StringUtils.isBlank((CharSequence)sqlSet)) {
            return;
        }
        String[] elArr = sqlSet.split(",");
        HashMap propMap = new HashMap(elArr.length);
        Arrays.stream(elArr).forEach(el -> {
            String[] elPart = el.split("=");
            propMap.put(elPart[0], elPart[1]);
        });
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            String fieldName;
            String fieldValue;
            EncryptedColumn sensitiveField = field.getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(sensitiveField) || !StringUtils.isNotBlank((CharSequence)(fieldValue = (String)propMap.get(fieldName = field.getName()))) || !(matcher = this.PARAM_PAIRS_RE.matcher(fieldValue)).matches()) continue;
            valueKey = matcher.group(1);
            value = updateWrapper.getParamNameValuePairs().get(valueKey);
            updateWrapper.getParamNameValuePairs().put(valueKey, this.encryptData(value.toString()));
        }
        for (Method method : declaredMethods = entityClass.getDeclaredMethods()) {
            String el2;
            EncryptedColumn sensitiveField = method.getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(sensitiveField) || !(matcher = this.PARAM_PAIRS_RE.matcher(el2 = (String)propMap.get(method.getName()))).matches()) continue;
            valueKey = matcher.group(1);
            value = updateWrapper.getParamNameValuePairs().get(valueKey);
            updateWrapper.getParamNameValuePairs().put(valueKey, this.encryptData(value.toString()));
        }
    }

    public abstract String encryptData(String var1);
}

