/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis.plus;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class CharacterEscapeInterceptor
implements Interceptor {
    Logger LOGGER = LoggerFactory.getLogger(CharacterEscapeInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement statement = (MappedStatement)args[0];
        Object parameterObject = args[1];
        BoundSql boundSql = statement.getBoundSql(parameterObject);
        String sql = boundSql.getSql();
        CharacterEscapeInterceptor.modifyLikeSql(sql, parameterObject, boundSql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static String modifyLikeSql(String sql, Object parameterObject, BoundSql boundSql) {
        if (!(parameterObject instanceof HashMap)) {
            return sql;
        }
        if (!sql.toLowerCase().contains(" like ") || !sql.toLowerCase().contains("?")) {
            return sql;
        }
        String[] strList = sql.split("\\?");
        HashSet<String> keyNames = new HashSet<String>();
        for (int i = 0; i < strList.length; ++i) {
            if (!strList[i].toLowerCase().contains(" like ")) continue;
            String keyName = ((ParameterMapping)boundSql.getParameterMappings().get(i)).getProperty();
            keyNames.add(keyName);
        }
        for (String keyName : keyNames) {
            Object a;
            HashMap parameter = (HashMap)parameterObject;
            if (keyName.contains("ew.paramNameValuePairs.") && sql.toLowerCase().contains(" like ?")) {
                String[] keyList;
                QueryWrapper wrapper = (QueryWrapper)parameter.get("ew");
                Object a2 = (parameter = (HashMap)wrapper.getParamNameValuePairs()).get((keyList = keyName.split("\\."))[2]);
                if (!(a2 instanceof String) || !a2.toString().contains("_") && !a2.toString().contains("\\") && !a2.toString().contains("%")) continue;
                parameter.put(keyList[2], "%" + CharacterEscapeInterceptor.escapeChar(a2.toString().substring(1, a2.toString().length() - 1)) + "%");
                continue;
            }
            if (!keyName.contains("ew.paramNameValuePairs.") && sql.toLowerCase().contains(" like ?")) {
                a = parameter.get(keyName);
                if (!(a instanceof String) || !a.toString().contains("_") && !a.toString().contains("\\") && !a.toString().contains("%")) continue;
                parameter.put(keyName, "%" + CharacterEscapeInterceptor.escapeChar(a.toString().substring(1, a.toString().length() - 1)) + "%");
                continue;
            }
            a = parameter.get(keyName);
            if (!(a instanceof String) || !a.toString().contains("_") && !a.toString().contains("\\") && !a.toString().contains("%")) continue;
            parameter.put(keyName, CharacterEscapeInterceptor.escapeChar(a.toString()));
        }
        return sql;
    }

    public static String escapeChar(String before) {
        if (StringUtils.isNotBlank((CharSequence)before)) {
            before = before.replaceAll("\\\\", "\\\\\\\\");
            before = before.replaceAll("_", "\\\\_");
            before = before.replaceAll("%", "\\\\%");
        }
        return before;
    }
}

