/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis;

import cn.aotcloud.mybatis.MyBatisXMLMapperBuilder;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;

public class MyBatisSqlSessionFactoryBean
extends SqlSessionFactoryBean {
    private Resource[] mapperLocations;
    private Configuration configuration;

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this.configuration = configuration;
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        SqlSessionFactory sqlSessionFactory = super.buildSqlSessionFactory();
        if (this.mapperLocations != null && this.mapperLocations.length > 0) {
            for (Resource mapperLocation : this.mapperLocations) {
                if (mapperLocation == null) continue;
                InputStream inputStream = null;
                try {
                    inputStream = mapperLocation.getInputStream();
                    MyBatisXMLMapperBuilder xmlMapperBuilder = new MyBatisXMLMapperBuilder(inputStream, this.configuration, mapperLocation.toString(), this.configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
                catch (Exception e) {
                    throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    ErrorContext.instance().reset();
                }
            }
        }
        return sqlSessionFactory;
    }
}

