/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.crypto.sm;

import cn.aotcloud.crypto.EncryptException;
import cn.aotcloud.crypto.sm.SMTextEncryptor;
import cn.aotcloud.smcrypto.Sm4Utils;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;
import cn.aotcloud.smcrypto.util.ByteUtils;
import org.springframework.util.Assert;

public class SM4TextEncryptor
extends SMTextEncryptor {
    public static final String SM4_ECB = "ECB";
    public static final String SM4_CBC = "CBC";
    protected String key;
    protected String iv;
    protected String type = "ECB";

    public SM4TextEncryptor(String key) {
        this(key, false);
    }

    public SM4TextEncryptor(String key, boolean hex) {
        Assert.notNull((Object)key, (String)"SM4\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        if (hex) {
            this.key = key;
            if (key.length() < 32) {
                throw new IllegalArgumentException("SM4\u5bc6\u94a5Hex\u5fc5\u987b\u4e0d\u80fd\u5c0f\u4e8e32\u4f4d");
            }
        } else {
            if (key.length() < 16) {
                throw new IllegalArgumentException("SM4\u5bc6\u94a5\u5fc5\u987b\u4e0d\u80fd\u5c0f\u4e8e16\u4f4d");
            }
            this.key = ByteUtils.stringToHex((String)key);
        }
    }

    public SM4TextEncryptor(String key, String iv, String type) {
        this(key);
        this.iv = iv;
        this.type = type;
    }

    public SM4TextEncryptor(String key, boolean hex, String iv, String type) {
        this(key, hex);
        this.iv = iv;
        this.type = type;
    }

    public String encrypt(String text) {
        try {
            if (SM4_ECB.equalsIgnoreCase(this.type)) {
                return Sm4Utils.ECB.encryptFromText((String)text, (String)this.key);
            }
            return Sm4Utils.CBC.encryptFromText((String)text, (String)this.key, (String)this.iv);
        }
        catch (InvalidKeyException | InvalidSourceDataException e) {
            throw new EncryptException(e, EncryptException.ENCRYPT_ERROR_CODE);
        }
    }

    public String decrypt(String encryptedText) {
        try {
            if (SM4_ECB.equalsIgnoreCase(this.type)) {
                return Sm4Utils.ECB.decryptToText((String)encryptedText, (String)this.key);
            }
            return Sm4Utils.CBC.decryptToText((String)encryptedText, (String)this.key, (String)this.iv);
        }
        catch (InvalidCryptoDataException | InvalidKeyException e) {
            throw new EncryptException(e, EncryptException.DECRYPT_ERROR_CODE);
        }
    }
}

