/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.crypto.sm;

import cn.aotcloud.crypto.DefaultRandomStringGenerator;
import cn.aotcloud.crypto.EncryptionProperties;
import cn.aotcloud.crypto.sm.SM2TextEncryptor;
import cn.aotcloud.crypto.sm.SM3TextEncryptor;
import cn.aotcloud.smcrypto.Sm2Utils;
import org.apache.commons.lang3.StringUtils;

public class SM2ToSM3TextEncryptor
extends SM2TextEncryptor {
    protected boolean toSM3 = true;
    protected SM3TextEncryptor sm3TextEncryptor = new SM3TextEncryptor();
    protected DefaultRandomStringGenerator randomStringGenerator = new DefaultRandomStringGenerator(8);

    @Deprecated
    public SM2ToSM3TextEncryptor(Sm2Utils sm2Utils, EncryptionProperties encryptionProperties) {
        this(sm2Utils, encryptionProperties, true);
    }

    @Deprecated
    public SM2ToSM3TextEncryptor(Sm2Utils sm2Utils, EncryptionProperties encryptionProperties, boolean toSM3) {
        super(sm2Utils, encryptionProperties);
        this.toSM3 = toSM3;
    }

    @Deprecated
    public SM2ToSM3TextEncryptor(Sm2Utils sm2Utils, String pubKeyHex, String prvKeyHex) {
        super(sm2Utils, pubKeyHex, prvKeyHex);
    }

    @Deprecated
    public SM2ToSM3TextEncryptor(Sm2Utils sm2Utils, String pubKeyHex, String prvKeyHex, boolean toSM3) {
        super(sm2Utils, pubKeyHex, prvKeyHex);
        this.toSM3 = toSM3;
    }

    public SM2ToSM3TextEncryptor(EncryptionProperties encryptionProperties) {
        this(encryptionProperties, true);
    }

    public SM2ToSM3TextEncryptor(EncryptionProperties encryptionProperties, boolean toSM3) {
        super(encryptionProperties);
        this.toSM3 = toSM3;
    }

    public SM2ToSM3TextEncryptor(String pubKeyHex, String prvKeyHex) {
        super(pubKeyHex, prvKeyHex);
    }

    public SM2ToSM3TextEncryptor(String pubKeyHex, String prvKeyHex, boolean toSM3) {
        super(pubKeyHex, prvKeyHex);
        this.toSM3 = toSM3;
    }

    @Override
    public String encrypt(String text) {
        return super.encrypt(this.encryptInternal(text));
    }

    protected String encryptInternal(String text) {
        return this.sm3Encrypt(text) + "|" + this.randomStringGenerator.getNewString() + "|" + text;
    }

    @Override
    public String decrypt(String encryptedText) {
        return this.sm2DecryptAndSm3VerifyRP(encryptedText);
    }

    public String decryptWithSM2(String encryptedText) {
        return super.decrypt(encryptedText);
    }

    public String sm2DecryptAndSm3VerifyRP(String cipherText) {
        return this.sm2DecryptAndSm3VerifyRP(cipherText, "\\|");
    }

    public String sm2DecryptAndSm3VerifyRP(String cipherText, String split) {
        if (StringUtils.isBlank((CharSequence)cipherText) || StringUtils.isBlank((CharSequence)split)) {
            return null;
        }
        String sec_p_sm3_random_plain = this.decryptWithSM2(cipherText);
        int sec_p_sm3_index = sec_p_sm3_random_plain.indexOf("|", 1);
        int sec_p_random_index = sec_p_sm3_random_plain.indexOf("|", sec_p_sm3_index + 1);
        String sec_p_sm3 = sec_p_sm3_random_plain.substring(0, sec_p_sm3_index);
        String sec_p_random = sec_p_sm3_random_plain.substring(sec_p_sm3_index + 1, sec_p_random_index);
        String sec_p_plain = sec_p_sm3_random_plain.substring(sec_p_random_index + 1, sec_p_sm3_random_plain.length());
        String plainToSm3 = null;
        if (StringUtils.isNotEmpty((CharSequence)sec_p_sm3) && StringUtils.isNotEmpty((CharSequence)sec_p_plain) && StringUtils.isNotEmpty((CharSequence)sec_p_random)) {
            plainToSm3 = this.sm3Encrypt(sec_p_plain);
            if (!sec_p_sm3.equalsIgnoreCase(plainToSm3)) {
                plainToSm3 = null;
            } else {
                if (this.toSM3) {
                    return plainToSm3;
                }
                return sec_p_plain;
            }
        }
        return null;
    }

    protected String sm3Encrypt(String text) {
        return this.sm3TextEncryptor.encrypt(text);
    }
}

