/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.crypto;

import cn.aotcloud.crypto.TextCryptoType;
import cn.aotcloud.crypto.pcode.BCryptPcodeEncoder;
import cn.aotcloud.crypto.pcode.Pbkdf2PcodeEncoder;
import cn.aotcloud.crypto.pcode.PcodeEncoder;
import cn.aotcloud.crypto.pcode.SCryptPcodeEncoder;
import cn.aotcloud.crypto.pcode.StandardPcodeEncoder;
import cn.aotcloud.crypto.sm.SMImplMode;
import cn.aotcloud.crypto.sm.SmKeyLoader;
import cn.aotcloud.crypto.sm.delegate.SMCryptoFactory;
import cn.aotcloud.smcrypto.Sm2Utils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.security.rsa.crypto.RsaAlgorithm;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(prefix="encrypt")
public class EncryptionProperties {
    private static final String DEFAULT_SM2_PUBLIC_KEY = "040ECAE82EA6BDC5FF6C90E6D8700F4F9BD44224E8F7F7576FA9B17CE823C18DD5C1D4F9CBF4EE23B3D3347C589036EE13E9497607D0F6C7B5CC655D0D250EDCE8";
    private static final String DEFAULT_SM2_PRIVATE_KEY = "7E94B2BE308639054B1714A758C27B6955CA702A70D906D603EA145AC0A2F079";
    private static final String DEFAULT_SM4_KEY = "4A65463855397748464F4D6673303033";
    private Boolean enabled = false;
    private boolean safeMode = false;
    private EncoderType encoderType = new EncoderType();
    private String symmetricKey;
    private boolean failOnError = true;
    private TextCryptoType text = TextCryptoType.none;
    private KeyStore keyStore = new KeyStore();
    private Rsa rsa;
    private String sm4Type;
    private String sm4Key;
    private String sm4KeyPrefix;
    private String sm4CbcIv;
    private String sm4CbcIvPrefix;
    private Sm2Key sm2Key;
    private boolean hasReBuildSmKey;
    private SMImplMode smImplMode;

    public EncryptionProperties() {
        if (ClassUtils.isPresent((String)"org.springframework.security.rsa.crypto.RsaAlgorithm", null)) {
            this.rsa = new Rsa();
        }
        this.sm4Type = "ECB";
        this.sm4Key = DEFAULT_SM4_KEY;
        this.sm4KeyPrefix = "4A65463855397748464F4D66";
        this.sm4CbcIv = "2092603DC7C046DCA20B61E086161C68";
        this.sm4CbcIvPrefix = "2092603DC7C046DCA20B61E0";
        this.hasReBuildSmKey = false;
        this.smImplMode = SMImplMode.java;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Rsa getRsa() {
        return this.rsa;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getKey() {
        return this.symmetricKey;
    }

    public void setKey(String key) {
        this.symmetricKey = key;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public EncoderType getEncoderType() {
        return this.encoderType;
    }

    public void setEncoderType(EncoderType encoderType) {
        this.encoderType = encoderType;
    }

    public TextCryptoType getText() {
        return this.text;
    }

    public void setText(TextCryptoType text) {
        this.text = text;
    }

    public String getSm4Key() {
        return this.sm4Key;
    }

    public void setSm4Key(String sm4Key) {
        this.sm4Key = sm4Key;
    }

    public String getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setSymmetricKey(String symmetricKey) {
        this.symmetricKey = symmetricKey;
    }

    public String getSm4KeyPrefix() {
        return this.sm4KeyPrefix;
    }

    public void setSm4KeyPrefix(String sm4KeyPrefix) {
        this.sm4KeyPrefix = sm4KeyPrefix;
    }

    public String getSm4CbcIvPrefix() {
        return this.sm4CbcIvPrefix;
    }

    public void setSm4CbcIvPrefix(String sm4CbcIvPrefix) {
        this.sm4CbcIvPrefix = sm4CbcIvPrefix;
    }

    public String getSm4Type() {
        return this.sm4Type;
    }

    public void setSm4Type(String sm4Type) {
        this.sm4Type = sm4Type;
    }

    public String getSm4CbcIv() {
        return this.sm4CbcIv;
    }

    public void setSm4CbcIv(String sm4CbcIv) {
        this.sm4CbcIv = sm4CbcIv;
    }

    public Sm2Key getSm2Key() {
        if (this.sm2Key == null) {
            this.sm2Key = new Sm2Key();
            this.sm2Key.setPrvKeyHex(DEFAULT_SM2_PRIVATE_KEY);
            this.sm2Key.setPubKeyHex(DEFAULT_SM2_PUBLIC_KEY);
        }
        return this.sm2Key;
    }

    public void setSm2Key(Sm2Key sm2Key) {
        this.sm2Key = sm2Key;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public SMImplMode getSmImplMode() {
        return this.smImplMode;
    }

    public void setSmImplMode(SMImplMode smImplMode) {
        this.smImplMode = smImplMode;
    }

    @Deprecated
    public Sm2Utils createSm2Util() {
        Sm2Utils sm2Utils = new Sm2Utils();
        return sm2Utils;
    }

    public void rebuildSmKey(SmKeyLoader keyLoader) {
        if (!this.hasReBuildSmKey) {
            String privateKey = keyLoader.getSm2PrivateKey(this.getSm2Key().getPrvKeyHexPrefix());
            String key = keyLoader.getSm4Key(this.getSm4KeyPrefix());
            String sm4CbcIv = keyLoader.getSm4CbcIv(this.getSm4CbcIvPrefix());
            this.getSm2Key().setPrvKeyHex(privateKey);
            this.setSm4Key(key);
            this.setSm4CbcIv(sm4CbcIv);
            this.hasReBuildSmKey = true;
        }
    }

    public PcodeEncoder createPcodeEncoder() {
        if (this.getEncoderType().getType().equals("bcrypt")) {
            return new BCryptPcodeEncoder(this.getEncoderType().getBcrypt().getStrength());
        }
        if (this.getEncoderType().getType().equals("scrypt")) {
            return new SCryptPcodeEncoder(this.getEncoderType().getScrypt().getCpuCost(), this.getEncoderType().getScrypt().getMemoryCost(), this.getEncoderType().getScrypt().getParallelization(), this.getEncoderType().getScrypt().getKeyLength(), this.getEncoderType().getScrypt().getSaltLength());
        }
        if (this.getEncoderType().getType().equals("pbkdf2")) {
            return new Pbkdf2PcodeEncoder(this.getEncoderType().getPbkdf2().getSecret(), this.getEncoderType().getPbkdf2().getIterations(), this.getEncoderType().getPbkdf2().getHashWidth());
        }
        if (this.getEncoderType().getType().equals("sm3")) {
            return SMCryptoFactory.createSM3PcodeEncoder(this.getSmImplMode());
        }
        return new StandardPcodeEncoder(this.getEncoderType().getStandard().getSecret());
    }

    public static class Sm2Key {
        private String pubKeyHex;
        private String prvKeyHex;
        private String prvKeyHexPrefix;

        public String getPubKeyHex() {
            return this.pubKeyHex;
        }

        public void setPubKeyHex(String pubKeyHex) {
            this.pubKeyHex = pubKeyHex;
        }

        public String getPrvKeyHex() {
            return this.prvKeyHex;
        }

        public void setPrvKeyHex(String prvKeyHex) {
            this.prvKeyHex = prvKeyHex;
        }

        public String getPrvKeyHexPrefix() {
            return this.prvKeyHexPrefix;
        }

        public void setPrvKeyHexPrefix(String prvKeyHexPrefix) {
            this.prvKeyHexPrefix = prvKeyHexPrefix;
        }
    }

    public static class Pbkdf2Authkey {
        private String secret;
        private int hashWidth;
        private int iterations;

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public int getHashWidth() {
            return this.hashWidth;
        }

        public void setHashWidth(int hashWidth) {
            this.hashWidth = hashWidth;
        }

        public int getIterations() {
            return this.iterations;
        }

        public void setIterations(int iterations) {
            this.iterations = iterations;
        }
    }

    public static class SCryptAuthkey {
        private int cpuCost = 16384;
        private int memoryCost = 8;
        private int parallelization = 1;
        private int keyLength = 32;
        private int saltLength = 64;

        public int getCpuCost() {
            return this.cpuCost;
        }

        public void setCpuCost(int cpuCost) {
            this.cpuCost = cpuCost;
        }

        public int getMemoryCost() {
            return this.memoryCost;
        }

        public void setMemoryCost(int memoryCost) {
            this.memoryCost = memoryCost;
        }

        public int getParallelization() {
            return this.parallelization;
        }

        public void setParallelization(int parallelization) {
            this.parallelization = parallelization;
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public void setKeyLength(int keyLength) {
            this.keyLength = keyLength;
        }

        public int getSaltLength() {
            return this.saltLength;
        }

        public void setSaltLength(int saltLength) {
            this.saltLength = saltLength;
        }
    }

    public static class BCryptAuthkey {
        private int strength;

        public int getStrength() {
            return this.strength;
        }

        public void setStrength(int strength) {
            this.strength = strength;
        }
    }

    public static class StandardAuthkey {
        private String algorithm = "SHA-256";
        private String secret = "secret";

        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }

    public static class EncoderType {
        private String type = "sm3";
        private StandardAuthkey standard = new StandardAuthkey();
        private BCryptAuthkey bcrypt = new BCryptAuthkey();
        private SCryptAuthkey scrypt = new SCryptAuthkey();
        private Pbkdf2Authkey pbkdf2 = new Pbkdf2Authkey();

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public StandardAuthkey getStandard() {
            return this.standard;
        }

        public void setStandard(StandardAuthkey standard) {
            this.standard = standard;
        }

        public BCryptAuthkey getBcrypt() {
            return this.bcrypt;
        }

        public void setBcrypt(BCryptAuthkey bcrypt) {
            this.bcrypt = bcrypt;
        }

        public Pbkdf2Authkey getPbkdf2() {
            return this.pbkdf2;
        }

        public void setPbkdf2(Pbkdf2Authkey pbkdf2) {
            this.pbkdf2 = pbkdf2;
        }

        public SCryptAuthkey getScrypt() {
            return this.scrypt;
        }

        public void setScrypt(SCryptAuthkey scrypt) {
            this.scrypt = scrypt;
        }
    }

    public static class Rsa {
        private RsaAlgorithm algorithm = RsaAlgorithm.DEFAULT;
        private boolean strong = false;
        private String salt = "deadbeef";

        public RsaAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(RsaAlgorithm algorithm) {
            this.algorithm = algorithm;
        }

        public boolean isStrong() {
            return this.strong;
        }

        public void setStrong(boolean strong) {
            this.strong = strong;
        }

        public String getSalt() {
            return this.salt;
        }

        public void setSalt(String salt) {
            this.salt = salt;
        }
    }

    public static class KeyStore {
        private Resource location;
        private String alias;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Resource getLocation() {
            return this.location;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }
    }
}

