/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.utils.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressUtil {
    private static final Logger logger = LoggerFactory.getLogger(CompressUtil.class);
    private static final int BUFFER_SIZE = 1024;

    public static String compressToZip(String sourcePath, String targetPath) {
        File sourceFile = CompressUtil.validateSourcePath(sourcePath);
        return CompressUtil.compressToZip(sourceFile, targetPath);
    }

    /*
     * Exception decompiling
     */
    public static String compressToZip(File sourceFile, String targetPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void compressToZip(File sourceFile, ZipOutputStream zipOut, String baseDir) throws IOException {
        if (sourceFile.isDirectory()) {
            CompressUtil.compressDirectoryToZip(sourceFile, zipOut, baseDir);
        } else {
            CompressUtil.compressFileToZip(sourceFile, zipOut, baseDir);
        }
    }

    private static void compressDirectoryToZip(File sourceFile, ZipOutputStream zipOut, String basePath) throws IOException {
        File[] files;
        for (File file : files = sourceFile.listFiles()) {
            CompressUtil.compressToZip(file, zipOut, basePath + sourceFile.getName() + File.separator);
        }
    }

    private static void compressFileToZip(File sourceFile, ZipOutputStream zipOut, String basePath) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        try (BufferedInputStream bis = new BufferedInputStream(FileUtil.newFileInputStream(sourceFile));){
            int count;
            ZipEntry entry = new ZipEntry(basePath + sourceFile.getName());
            zipOut.putNextEntry(entry);
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                zipOut.write(data, 0, count);
            }
        }
    }

    public static String unpackExportZipEntry(ZipFile zipFile, ZipEntry entry, String targetPath) throws IOException {
        File targetDir = CompressUtil.validateTargetPath(targetPath);
        String entryName = entry.getName();
        entryName = StringUtils.replace((String)entryName, (String)"/", (String)File.separator);
        File tempFile = new File(targetDir, entryName = StringUtils.substringAfter((String)entryName, (String)File.separator));
        if (!tempFile.getParentFile().exists()) {
            tempFile.getParentFile().mkdirs();
        }
        tempFile.createNewFile();
        try (InputStream is = zipFile.getInputStream(entry);
             FileOutputStream fos = FileUtil.newFileOutputStream(tempFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
        }
        CompressUtil.unpackZip(targetPath + File.separator + entryName, targetPath);
        tempFile.delete();
        return targetPath + File.separator + StringUtils.substringBeforeLast((String)entryName, (String)".");
    }

    public static void unpackZip(String sourcePath, String targetPath) {
        File sourceFile = CompressUtil.validateSourcePath(sourcePath);
        CompressUtil.unpackZip(sourceFile, targetPath);
    }

    public static void unpackZip(File sourceFile, String targetPath) {
        CompressUtil.validateTargetPath(targetPath);
        try (ZipFile zipFile = new ZipFile(sourceFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirPath = targetPath + File.separator + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                File tempFile = new File(targetPath + File.separator + entry.getName());
                if (!tempFile.getParentFile().exists()) {
                    tempFile.getParentFile().mkdirs();
                }
                tempFile.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream fos = FileUtil.newFileOutputStream(tempFile);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buf = new byte[1024];
                        while ((len = is.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("unpack zip throw exception:{}", (Throwable)e);
        }
    }

    public static File validateSourcePath(String sourcePath) {
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            logger.error("the source file is not exist, source path: {}", (Object)sourceFile.getAbsolutePath());
            throw new RuntimeException("the source file is not exist");
        }
        return sourceFile;
    }

    public static File validateTargetPath(String targetPath) {
        File targetFile = new File(targetPath);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        return targetFile;
    }

    public static void compressNoParentZip(File sourceFile, ZipOutputStream zos, String name) throws IOException {
        byte[] buf = new byte[1024];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = FileUtil.newFileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                zos.putNextEntry(new ZipEntry(""));
                zos.closeEntry();
            } else {
                for (File file : listFiles) {
                    CompressUtil.compressNoParentZip(file, zos, file.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> unZip(InputStream input, String fileId, String scanDir) throws IOException {
        int BUFFER_SIZE = 1024;
        File destFile = FileUtil.newFile(scanDir, FilenameUtils.normalize((String)fileId));
        if (FileUtil.exists(destFile)) {
            destFile.delete();
        }
        FileUtil.mkdirs(destFile);
        ZipArchiveInputStream is = null;
        BufferedInputStream bis = null;
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            bis = new BufferedInputStream(input, BUFFER_SIZE);
            is = CompressUtil.isWindows() ? new ZipArchiveInputStream((InputStream)bis, "GBK") : new ZipArchiveInputStream((InputStream)bis);
            ZipArchiveEntry entry = null;
            while ((entry = is.getNextEntry()) != null) {
                fileNames.add(entry.getName());
                if (entry.isDirectory()) {
                    File directory = FileUtil.newFile(destFile, FilenameUtils.normalize((String)entry.getName()));
                    FileUtil.mkdirs(directory);
                    continue;
                }
                FileOutputStream fos = null;
                BufferedOutputStream os = null;
                try {
                    File file = FileUtil.newFile(destFile, FilenameUtils.normalize((String)entry.getName()));
                    FileUtil.mkdirs(file.getParentFile());
                    fos = FileUtil.newFileOutputStream(file);
                    os = new BufferedOutputStream(fos, BUFFER_SIZE);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
        catch (IOException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)is);
        return fileNames;
    }

    private static boolean isWindows() {
        Properties prop = System.getProperties();
        String osName = prop.getProperty("os.name");
        return StringUtils.startsWithIgnoreCase((CharSequence)osName, (CharSequence)"win");
    }
}

