/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.redis;

import cn.aotcloud.exception.BaseExceptionEmpty;
import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.prop.RedisSafeProperties;
import cn.aotcloud.smcrypto.Sm3Utils;
import cn.aotcloud.smcrypto.Sm4Utils;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class RedisConfig {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final RedisSafeProperties redisSafeProperties;
    protected final RedisProperties redisProperties;

    public RedisConfig(RedisSafeProperties redisSafeProperties, RedisProperties redisProperties) {
        this.redisSafeProperties = redisSafeProperties;
        this.redisProperties = redisProperties;
    }

    public LettuceConnectionFactory lettuceConnectionFactory(String sm4K, String sm4v, String salt) {
        String host = this.getHost(sm4K, sm4v, salt);
        String username = this.getUsername(sm4K, sm4v, salt);
        String password = this.getPassword(sm4K, sm4v, salt);
        GenericObjectPoolConfig genericObjectPoolConfig = null;
        LettucePoolingClientConfiguration clientConfig = null;
        RedisProperties.Lettuce lettuce = this.redisProperties.getLettuce();
        if (lettuce != null) {
            RedisProperties.Pool lettucePool = this.redisProperties.getLettuce().getPool();
            if (lettucePool != null) {
                genericObjectPoolConfig = new GenericObjectPoolConfig();
                genericObjectPoolConfig.setMaxIdle(lettucePool.getMaxIdle());
                genericObjectPoolConfig.setMinIdle(lettucePool.getMinIdle());
                genericObjectPoolConfig.setMaxTotal(lettucePool.getMaxActive());
                if (lettucePool.getMaxWait() != null) {
                    genericObjectPoolConfig.setMaxWaitMillis(lettucePool.getMaxWait().getSeconds() * 1000L);
                }
                if (lettucePool.getTimeBetweenEvictionRuns() != null) {
                    genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(lettucePool.getTimeBetweenEvictionRuns().getSeconds() * 1000L);
                }
            }
            LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder lettucePoolingClientConfigurationBuilder = LettucePoolingClientConfiguration.builder();
            if (this.redisProperties.getTimeout() != null) {
                lettucePoolingClientConfigurationBuilder.commandTimeout(this.redisProperties.getTimeout());
            }
            if (lettuce.getShutdownTimeout() != null) {
                lettucePoolingClientConfigurationBuilder.shutdownTimeout(lettuce.getShutdownTimeout());
            }
            if (genericObjectPoolConfig != null) {
                lettucePoolingClientConfigurationBuilder.poolConfig(genericObjectPoolConfig);
            }
            clientConfig = lettucePoolingClientConfigurationBuilder.build();
        }
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setDatabase(this.redisProperties.getDatabase());
        redisStandaloneConfiguration.setHostName(host);
        redisStandaloneConfiguration.setPort(this.redisProperties.getPort());
        if (StringUtils.isNotBlank((CharSequence)username)) {
            redisStandaloneConfiguration.setUsername(username);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            redisStandaloneConfiguration.setPassword(RedisPassword.of((String)password));
        }
        if (clientConfig != null) {
            return new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)clientConfig);
        }
        return new LettuceConnectionFactory(redisStandaloneConfiguration);
    }

    public String getHost(String sm4K, String sm4v, String salt) {
        String dz = this.redisSafeProperties.getDz();
        if (StringUtils.isNotBlank((CharSequence)dz)) {
            if (StringUtils.startsWith((CharSequence)dz, (CharSequence)"enc(")) {
                try {
                    String dze = StringUtils.substringBetween((String)dz, (String)"enc(", (String)"|");
                    String sm3 = StringUtils.substringBetween((String)dz, (String)"|", (String)")");
                    dz = Sm4Utils.CBC.decryptToText((String)dze, (String)sm4K, (String)sm4v);
                    if (!this.verifySm3(dz, salt, sm3)) {
                        throw new BaseExceptionEmpty("Redis\u5730\u5740\u88ab\u7be1\u6539");
                    }
                    this.logger.info("Redis\u5730\u5740\u89e3\u5bc6\u540e\u88c5\u8f7d\u6210\u529f");
                }
                catch (InvalidCryptoDataException e) {
                    this.logger.error("Redis\u5730\u5740\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
                catch (InvalidKeyException e) {
                    this.logger.error("Redis\u5730\u5740\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            } else {
                this.logger.info("Redis\u5730\u5740\u660e\u6587\u88c5\u8f7d\u6210\u529f");
            }
            return dz;
        }
        this.logger.info("Redis\u5730\u5740\u9ed8\u8ba4\u88c5\u8f7d\u6210\u529f");
        return this.redisProperties.getHost();
    }

    public String getUsername(String sm4K, String sm4v, String salt) {
        String un = this.redisSafeProperties.getUn();
        if (StringUtils.isNotBlank((CharSequence)un)) {
            if (StringUtils.startsWith((CharSequence)un, (CharSequence)"enc(")) {
                try {
                    String une = StringUtils.substringBetween((String)un, (String)"enc(", (String)"|");
                    String sm3 = StringUtils.substringBetween((String)un, (String)"|", (String)")");
                    un = Sm4Utils.CBC.decryptToText((String)une, (String)sm4K, (String)sm4v);
                    if (!this.verifySm3(un, salt, sm3)) {
                        throw new BaseExceptionEmpty("Redis\u7528\u6237\u540d\u88ab\u7be1\u6539");
                    }
                    this.logger.info("Redis\u7528\u6237\u540d\u89e3\u5bc6\u540e\u88c5\u8f7d\u6210\u529f");
                }
                catch (InvalidCryptoDataException e) {
                    this.logger.error("Redis\u7528\u6237\u540d\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
                catch (InvalidKeyException e) {
                    this.logger.error("Redis\u7528\u6237\u540d\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            } else {
                this.logger.info("Redis\u7528\u6237\u540d\u660e\u6587\u88c5\u8f7d\u6210\u529f");
            }
            return un;
        }
        this.logger.info("Redis\u7528\u6237\u540d\u9ed8\u8ba4\u88c5\u8f7d\u6210\u529f");
        return this.redisProperties.getUsername();
    }

    public String getPassword(String sm4K, String sm4v, String salt) {
        String pw = this.redisSafeProperties.getPw();
        if (StringUtils.isNotBlank((CharSequence)pw)) {
            if (StringUtils.startsWith((CharSequence)pw, (CharSequence)"enc(")) {
                try {
                    String pwe = StringUtils.substringBetween((String)pw, (String)"enc(", (String)"|");
                    String sm3 = StringUtils.substringBetween((String)pw, (String)"|", (String)")");
                    pw = Sm4Utils.CBC.decryptToText((String)pwe, (String)sm4K, (String)sm4v);
                    if (!this.verifySm3(pw, salt, sm3)) {
                        throw new BaseExceptionEmpty("Redis\u5bc6\u7801\u88ab\u7be1\u6539");
                    }
                    this.logger.info("Redis\u5bc6\u7801\u89e3\u5bc6\u540e\u88c5\u8f7d\u6210\u529f");
                }
                catch (InvalidCryptoDataException e) {
                    this.logger.error("Redis\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
                catch (InvalidKeyException e) {
                    this.logger.error("Redis\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            } else {
                this.logger.info("Redis\u5bc6\u7801\u660e\u6587\u88c5\u8f7d\u6210\u529f");
            }
            return pw;
        }
        this.logger.info("Redis\u5bc6\u7801\u9ed8\u8ba4\u88c5\u8f7d\u6210\u529f");
        return this.redisProperties.getPassword();
    }

    private boolean verifySm3(String data, String salt, String sm3) {
        try {
            String sm3_ = Sm3Utils.encryptFromText((String)(data + salt));
            return StringUtils.equals((CharSequence)sm3, (CharSequence)sm3_);
        }
        catch (InvalidSourceDataException e) {
            this.logger.error("SM3\u8ba1\u7b97\u5f02\u5e38\uff1a{}", (Object)ExceptionUtil.getMessage(e));
            return false;
        }
    }
}

