/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis.utils;

import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.mybatis.annotation.EncryptedColumn;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EncryptedColumnUtil {
    protected static LoggerHandle logger = new LoggerHandle(EncryptedColumnUtil.class);

    public static List<String> getEncryptedFieldName(Object result) {
        List<String> nameList = EncryptedColumnUtil.getEncryptedFieldName(result, EncryptedColumn.class);
        return nameList;
    }

    public static <T extends Annotation> List<String> getEncryptedFieldName(Object result, Class<T> clz) {
        ArrayList nameList = Lists.newArrayList();
        try {
            Field[] declaredFields;
            Class<?> resultClass = result.getClass();
            for (Field field : declaredFields = resultClass.getDeclaredFields()) {
                T encryptedField = field.getAnnotation(clz);
                if (Objects.isNull(encryptedField)) continue;
                nameList.add(field.getName());
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("\u83b7\u53d6\u52a0\u5bc6\u5b57\u6bb5\u5c5e\u6027\u540d\u79f0\u65f6\u5f02\u5e38\uff1a{}", ExceptionUtil.getMessage(e));
        }
        return nameList;
    }

    public static String getIdColumnValue(Object result) {
        try {
            Class<?> resultClass = result.getClass();
            Field idField = resultClass.getDeclaredField("id");
            idField.setAccessible(true);
            String id = String.valueOf(idField.get(result));
            return id;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.error("\u83b7\u53d6\u4e3b\u952eID\u65f6\u5f02\u5e38\uff1a{}", ExceptionUtil.getMessage(e));
            return null;
        }
    }

    public static List<Field> getEncryptedColumnValue(Object result) {
        ArrayList fieldList = Lists.newArrayList();
        try {
            Field[] declaredFields;
            Class<?> resultClass = result.getClass();
            for (Field field : declaredFields = resultClass.getDeclaredFields()) {
                EncryptedColumn sensitiveField = field.getAnnotation(EncryptedColumn.class);
                if (Objects.isNull(sensitiveField)) continue;
                field.setAccessible(true);
                Object object = field.get(result);
                if (!(object instanceof String)) continue;
                fieldList.add(field);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error("\u83b7\u53d6\u89e3\u5bc6\u5b57\u6bb5\u65f6\u5f02\u5e38\uff1a{}", ExceptionUtil.getMessage(e));
        }
        return fieldList;
    }

    public static void setColumnValue(Object result, Field field, String data) {
        try {
            field.set(result, data);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error("\u8bbe\u7f6e\u89e3\u5bc6\u5b57\u6bb5\u65f6\u5f02\u5e38\uff1a{}", ExceptionUtil.getMessage(e));
        }
    }
}

