/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis.plus;

import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.mybatis.annotation.EncryptedColumn;
import cn.aotcloud.mybatis.annotation.EncryptedTable;
import cn.aotcloud.smcrypto.util.StringUtils;
import cn.aotcloud.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class ColumnDecryptInterceptor
implements Interceptor {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());

    public Object intercept(Invocation invocation) throws Throwable {
        Object resultObject = invocation.proceed();
        if (Objects.isNull(resultObject)) {
            return null;
        }
        if (resultObject instanceof ArrayList) {
            ArrayList resultList = (ArrayList)resultObject;
            if (!resultList.isEmpty() && this.needToDecrypt(resultList.get(0))) {
                for (Object result : resultList) {
                    this.decrypt(result);
                }
            }
        } else if (this.needToDecrypt(resultObject)) {
            this.decrypt(resultObject);
        }
        return resultObject;
    }

    private boolean needToDecrypt(Object object) {
        Class<?> objectClass = object.getClass();
        EncryptedTable sensitiveData = (EncryptedTable)AnnotationUtils.findAnnotation(objectClass, EncryptedTable.class);
        return Objects.nonNull(sensitiveData);
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    private <T> T decrypt(T result) throws Exception {
        Field[] declaredFields;
        Class<?> resultClass = result.getClass();
        for (Field field : declaredFields = resultClass.getDeclaredFields()) {
            EncryptedColumn sensitiveField = field.getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(result);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            String data = this.decryptData(resultClass.getSimpleName(), field.getName(), result, value);
            field.set(result, data);
        }
        return result;
    }

    public String getKey(Object result) {
        String val = this.getFieldStringVal(result, "agentId");
        if (val == null) {
            val = this.getFieldStringVal(result, "id");
        }
        return val;
    }

    public String getFieldStringVal(Object result, String key) {
        if (result != null && StringUtils.isNotBlank((CharSequence)key)) {
            try {
                Object val = ReflectionUtils.getFieldValue(result, key);
                if (val != null && val instanceof String) {
                    return (String)val;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.logger.taskInfo("[Scheduled]", "\u83b7\u53d6\u8bc6\u522bID\u5f02\u5e38:{}", ExceptionUtil.getMessage(e));
            }
        }
        return null;
    }

    public abstract String decryptData(String var1, String var2, Object var3, String var4);
}

