/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis;

import cn.aotcloud.cache.CacheStorage;
import cn.aotcloud.cache.MemoryCacheStorage;
import cn.aotcloud.cache.NoneCacheStorage;
import cn.aotcloud.cache.RedisCacheStorage;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class SqlExecuteTimeCountInterceptor
implements Interceptor {
    protected static Logger logger = LoggerFactory.getLogger(SqlExecuteTimeCountInterceptor.class);
    private Map<String, String> debugClassName = Maps.newHashMap();
    private static final String DEFAULT_CONSTANTS = "ac:constants:debug";
    private static CacheStorage<String> cacheStorage;

    public SqlExecuteTimeCountInterceptor(SessionProperties sessionProperties, RedisConnectionFactory connectionFactory, boolean isEnableDebug) {
        cacheStorage = sessionProperties != null && sessionProperties.getStoreType() == StoreType.REDIS ? new RedisCacheStorage<String>(connectionFactory, DEFAULT_CONSTANTS, -1L) : (sessionProperties != null && sessionProperties.getStoreType() == StoreType.NONE ? new MemoryCacheStorage<String>(DEFAULT_CONSTANTS, -1L) : new NoneCacheStorage<String>());
        SqlExecuteTimeCountInterceptor.setDebugEnabled(isEnableDebug);
    }

    public void setDebugClassName(Map<String, String> debugClassName) {
        this.debugClassName = debugClassName;
    }

    public static void setDebugEnabled(boolean debugEnabled) {
        cacheStorage.addCache("debugEnabled", String.valueOf(debugEnabled));
    }

    public static boolean getDebugEnabled() {
        String debugEnabled = cacheStorage.getCache("debugEnabled");
        return StringUtils.equalsIgnoreCase((CharSequence)debugEnabled, (CharSequence)"true");
    }

    public Object intercept(Invocation invocation) throws Throwable {
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation, Method saveQueueMethod) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlId = mappedStatement.getId();
        String className = StringUtils.substringBeforeLast((String)sqlId, (String)".");
        if (SqlExecuteTimeCountInterceptor.getDebugEnabled() && this.debugClassName.containsKey(className)) {
            Object object;
            long startTime = System.currentTimeMillis();
            String sql = null;
            try {
                Object parameter = null;
                if (invocation.getArgs().length > 1) {
                    parameter = invocation.getArgs()[1];
                }
                BoundSql boundSql = mappedStatement.getBoundSql(parameter);
                Configuration configuration = mappedStatement.getConfiguration();
                sql = this.getSql(configuration, boundSql);
                object = invocation.proceed();
            }
            catch (Throwable throwable) {
                long timeCount = System.currentTimeMillis() - startTime;
                if (saveQueueMethod != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("debugType", "\u6570\u636e\u5e93\u8c03\u8bd5");
                    map.put("debugModel", this.debugClassName.get(className));
                    map.put("debugContent", sql);
                    map.put("debugTime", String.valueOf(timeCount));
                    map.put("debugResult", "\u6210\u529f");
                    saveQueueMethod.invoke(null, map);
                }
                logger.info("\u6267\u884cSQL\u8bed\u53e5\uff1a" + sql + " \u8017\u65f6\uff1a" + timeCount + "ms");
                throw throwable;
            }
            long timeCount = System.currentTimeMillis() - startTime;
            if (saveQueueMethod != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("debugType", "\u6570\u636e\u5e93\u8c03\u8bd5");
                map.put("debugModel", this.debugClassName.get(className));
                map.put("debugContent", sql);
                map.put("debugTime", String.valueOf(timeCount));
                map.put("debugResult", "\u6210\u529f");
                saveQueueMethod.invoke(null, map);
            }
            logger.info("\u6267\u884cSQL\u8bed\u53e5\uff1a" + sql + " \u8017\u65f6\uff1a" + timeCount + "ms");
            return object;
        }
        return invocation.proceed();
    }

    private String getSql(Configuration configuration, BoundSql boundSql) {
        String sql = this.showSql(configuration, boundSql);
        StringBuilder str = new StringBuilder(512);
        str.append("\u8c03\u8bd5\u6267\u884cSQL\u8bed\u53e5");
        str.append(" : ");
        str.append(sql);
        return str.toString();
    }

    private String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    private String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (CollectionUtils.isNotEmpty((Collection)parameterMappings) && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    sql = sql.replaceFirst("\\?", "\u7f3a\u5931");
                }
            }
        }
        return sql;
    }

    public Object plugin(Object target) {
        return super.plugin(target);
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
    }
}

