/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.crypto.sm.jni;

import cn.aotcloud.crypto.EncryptException;
import cn.aotcloud.crypto.sm.SM4TextEncryptor;
import cn.aotcloud.smcrypto.Sm4Utils;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;

public class SM4NativeTextEncryptor
extends SM4TextEncryptor {
    public SM4NativeTextEncryptor(String key) {
        super(key);
    }

    public SM4NativeTextEncryptor(String key, String iv, String type) {
        super(key, iv, type);
    }

    public SM4NativeTextEncryptor(String key, boolean hex) {
        super(key, hex);
    }

    public SM4NativeTextEncryptor(String key, boolean hex, String iv, String type) {
        super(key, hex, iv, type);
    }

    @Override
    public String encrypt(String text) {
        try {
            if ("ECB".equalsIgnoreCase(this.type)) {
                return Sm4Utils.ECB.encryptFromText((String)text, (String)this.key);
            }
            return Sm4Utils.CBC.encryptFromText((String)text, (String)this.key, (String)this.iv);
        }
        catch (InvalidKeyException | InvalidSourceDataException e) {
            throw new EncryptException(e, EncryptException.ENCRYPT_ERROR_CODE);
        }
    }

    @Override
    public String decrypt(String encryptedText) {
        try {
            if ("ECB".equalsIgnoreCase(this.type)) {
                return Sm4Utils.ECB.decryptToText((String)encryptedText, (String)this.key);
            }
            return Sm4Utils.CBC.decryptToText((String)encryptedText, (String)this.key, (String)this.iv);
        }
        catch (InvalidCryptoDataException | InvalidKeyException e) {
            throw new EncryptException(e, EncryptException.DECRYPT_ERROR_CODE);
        }
    }
}

