/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.crypto.sm.jni;

import cn.aotcloud.crypto.EncryptException;
import cn.aotcloud.crypto.EncryptionProperties;
import cn.aotcloud.crypto.sm.SM2TextEncryptor;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.smcrypto.Sm2Utils;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;

public class SM2NativeTextEncryptor
extends SM2TextEncryptor {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());

    public SM2NativeTextEncryptor(EncryptionProperties encryptionProperties) {
        this(encryptionProperties.getSm2Key().getPubKeyHex(), encryptionProperties.getSm2Key().getPrvKeyHex());
    }

    public SM2NativeTextEncryptor(String pubKeyHex, String prvKeyHex) {
        super(pubKeyHex, prvKeyHex);
    }

    @Override
    public String encrypt(String text) {
        try {
            return this.getNativeSm2Utils().encryptFromText(this.getPubKeyHex(), text);
        }
        catch (InvalidKeyException | InvalidSourceDataException e) {
            this.logger.error("SM2 \u52a0\u5bc6\u5931\u8d25\u3002", e);
            throw new EncryptException(e, EncryptException.ENCRYPT_ERROR_CODE);
        }
    }

    @Override
    public String decrypt(String encryptedText) {
        try {
            return this.getNativeSm2Utils().decryptToText(this.getPrvKeyHex(), encryptedText);
        }
        catch (InvalidCryptoDataException | InvalidKeyException e) {
            this.logger.error("SM2 \u89e3\u5bc6\u5931\u8d25\u3002", e);
            throw new EncryptException(e, EncryptException.DECRYPT_ERROR_CODE);
        }
    }

    public Sm2Utils getNativeSm2Utils() {
        return this.createNativeSm2Util();
    }

    public Sm2Utils createNativeSm2Util() {
        Sm2Utils sm2Utils = new Sm2Utils();
        return sm2Utils;
    }
}

