/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.crypto.sm;

import cn.aotcloud.crypto.pcode.PcodeEncoder;
import cn.aotcloud.crypto.sm.SM3TextEncryptor;
import cn.aotcloud.crypto.sm.SMTextEncryptor;

public class SM3PcodeEncoder
implements PcodeEncoder {
    private static final SM3PcodeEncoder pcodeEncoder = new SM3PcodeEncoder();
    private SMTextEncryptor textEncryptor = new SM3TextEncryptor();

    public static SM3PcodeEncoder getInstance() {
        return pcodeEncoder;
    }

    public String encode(CharSequence rawPcode) {
        if (rawPcode == null) {
            return null;
        }
        return this.textEncryptor.encrypt(rawPcode.toString());
    }

    public boolean matches(CharSequence rawPcode, String encodedPcode) {
        if (encodedPcode.equalsIgnoreCase((String)rawPcode)) {
            return true;
        }
        String inputPassword = this.encode(rawPcode);
        return inputPassword.equalsIgnoreCase(encodedPcode);
    }
}

