/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.crypto.sm;

import cn.aotcloud.crypto.EncryptException;
import cn.aotcloud.crypto.EncryptionProperties;
import cn.aotcloud.crypto.rsa.RsaPublicCode;
import cn.aotcloud.crypto.rsa.RsaPublicCodeHolder;
import cn.aotcloud.crypto.sm.SMTextEncryptor;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.smcrypto.Sm2Utils;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;

public class SM2TextEncryptor
extends SMTextEncryptor
implements RsaPublicCodeHolder {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());
    private final String pubKeyHex;
    private final String prvKeyHex;

    @Deprecated
    public SM2TextEncryptor(Sm2Utils sm2Utils, EncryptionProperties encryptionProperties) {
        this(sm2Utils, encryptionProperties.getSm2Key().getPubKeyHex(), encryptionProperties.getSm2Key().getPrvKeyHex());
    }

    @Deprecated
    public SM2TextEncryptor(Sm2Utils sm2Utils, String pubKeyHex, String prvKeyHex) {
        this.pubKeyHex = pubKeyHex;
        this.prvKeyHex = prvKeyHex;
    }

    public SM2TextEncryptor(EncryptionProperties encryptionProperties) {
        this(encryptionProperties.getSm2Key().getPubKeyHex(), encryptionProperties.getSm2Key().getPrvKeyHex());
    }

    public SM2TextEncryptor(String pubKeyHex, String prvKeyHex) {
        this.pubKeyHex = pubKeyHex;
        this.prvKeyHex = prvKeyHex;
    }

    public String encrypt(String text) {
        try {
            return this.getSm2Utils().encryptFromText(this.pubKeyHex, text);
        }
        catch (InvalidKeyException | InvalidSourceDataException e) {
            this.logger.error("SM2 \u52a0\u5bc6\u5931\u8d25\u3002", e);
            throw new EncryptException(e, EncryptException.ENCRYPT_ERROR_CODE);
        }
    }

    public String decrypt(String encryptedText) {
        try {
            return this.getSm2Utils().decryptToText(this.prvKeyHex, encryptedText);
        }
        catch (InvalidCryptoDataException | InvalidKeyException e) {
            this.logger.error("SM2 \u89e3\u5bc6\u5931\u8d25\u3002", e);
            throw new EncryptException(e, EncryptException.DECRYPT_ERROR_CODE);
        }
    }

    @Override
    public RsaPublicCode getRsaPublicCode() {
        RsaPublicCode rsaPublicKey = new RsaPublicCode();
        rsaPublicKey.setExponent(this.pubKeyHex);
        return rsaPublicKey;
    }

    public Sm2Utils getSm2Utils() {
        return this.createSm2Util();
    }

    public Sm2Utils createSm2Util() {
        Sm2Utils sm2Utils = new Sm2Utils();
        return sm2Utils;
    }

    public String getPubKeyHex() {
        return this.pubKeyHex;
    }

    public String getPrvKeyHex() {
        return this.prvKeyHex;
    }
}

