/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.codecs;

import cn.aotcloud.codecs.AbstractCharacterCodec;
import cn.aotcloud.codecs.PushbackSequence;

public class VBScriptCodec
extends AbstractCharacterCodec {
    public static final char[] CHAR_ALPHANUMERICS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    @Override
    public String encode(char[] immune, String input) {
        StringBuilder sb = new StringBuilder();
        boolean encoding = false;
        boolean inquotes = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (this.containsCharacter(c, CHAR_ALPHANUMERICS) || this.containsCharacter(c, immune)) {
                if (encoding && i > 0) {
                    sb.append("&");
                }
                if (!inquotes && i > 0) {
                    sb.append("\"");
                }
                sb.append(c);
                inquotes = true;
                encoding = false;
                continue;
            }
            if (inquotes && i < input.length()) {
                sb.append("\"");
            }
            if (i > 0) {
                sb.append("&");
            }
            sb.append(this.encodeCharacter(immune, Character.valueOf(c)));
            inquotes = false;
            encoding = true;
        }
        return sb.toString();
    }

    @Override
    public String encodeCharacter(char[] immune, Character c) {
        char ch = c.charValue();
        if (this.containsCharacter(ch, immune)) {
            return "" + ch;
        }
        String hex = super.getHexForNonAlphanumeric(ch);
        if (hex == null) {
            return "" + ch;
        }
        return "chrw(" + c.charValue() + ")";
    }

    @Override
    public Character decodeCharacter(PushbackSequence<Character> input) {
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\"') {
            input.reset();
            return null;
        }
        Character second = input.next();
        return second;
    }
}

