/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.codecs;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public interface Trie<T>
extends Map<CharSequence, T> {
    public Map.Entry<CharSequence, T> getLongestMatch(CharSequence var1);

    public Map.Entry<CharSequence, T> getLongestMatch(PushbackReader var1) throws IOException;

    public int getMaxKeyLength();

    public static class Util {
        private Util() {
        }

        static <T> Trie<T> unmodifiable(Trie<T> toWrap) {
            return new Unmodifiable<T>(toWrap);
        }
    }

    public static class Unmodifiable<T>
    extends TrieProxy<T> {
        Unmodifiable(Trie<T> toWrap) {
            super(toWrap);
        }

        @Override
        public T put(CharSequence key, T value) {
            throw new UnsupportedOperationException("Unmodifiable Trie");
        }

        public T remove(CharSequence key) {
            throw new UnsupportedOperationException("Unmodifiable Trie");
        }

        @Override
        public void putAll(Map<? extends CharSequence, ? extends T> t) {
            throw new UnsupportedOperationException("Unmodifiable Trie");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable Trie");
        }

        @Override
        public Set<CharSequence> keySet() {
            return Collections.unmodifiableSet(super.keySet());
        }

        @Override
        public Collection<T> values() {
            return Collections.unmodifiableCollection(super.values());
        }

        @Override
        public Set<Map.Entry<CharSequence, T>> entrySet() {
            return Collections.unmodifiableSet(super.entrySet());
        }
    }

    public static class TrieProxy<T>
    implements Trie<T> {
        private Trie<T> wrapped;

        TrieProxy(Trie<T> toWrap) {
            this.wrapped = toWrap;
        }

        protected Trie<T> getWrapped() {
            return this.wrapped;
        }

        @Override
        public Map.Entry<CharSequence, T> getLongestMatch(CharSequence key) {
            return this.wrapped.getLongestMatch(key);
        }

        @Override
        public Map.Entry<CharSequence, T> getLongestMatch(PushbackReader keyIn) throws IOException {
            return this.wrapped.getLongestMatch(keyIn);
        }

        @Override
        public int getMaxKeyLength() {
            return this.wrapped.getMaxKeyLength();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.wrapped.containsKey(key);
        }

        @Override
        public boolean containsValue(Object val) {
            return this.wrapped.containsValue(val);
        }

        @Override
        public T get(Object key) {
            return (T)this.wrapped.get(key);
        }

        @Override
        public T put(CharSequence key, T value) {
            return this.wrapped.put(key, value);
        }

        @Override
        public T remove(Object key) {
            return (T)this.wrapped.remove(key);
        }

        @Override
        public void putAll(Map<? extends CharSequence, ? extends T> t) {
            this.wrapped.putAll(t);
        }

        @Override
        public void clear() {
            this.wrapped.clear();
        }

        @Override
        public Set<CharSequence> keySet() {
            return this.wrapped.keySet();
        }

        @Override
        public Collection<T> values() {
            return this.wrapped.values();
        }

        @Override
        public Set<Map.Entry<CharSequence, T>> entrySet() {
            return this.wrapped.entrySet();
        }

        @Override
        public boolean equals(Object other) {
            return this.wrapped.equals(other);
        }

        @Override
        public int hashCode() {
            return this.wrapped.hashCode();
        }
    }
}

