/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.codecs;

import cn.aotcloud.codecs.AbstractPushbackSequence;

public class PushbackString
extends AbstractPushbackSequence<Character> {
    public PushbackString(String input) {
        super(input);
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        if (this.pushback != null) {
            return true;
        }
        if (this.input == null) {
            return false;
        }
        if (this.input.length() == 0) {
            return false;
        }
        return this.index < this.input.length();
    }

    @Override
    public Character next() {
        if (this.pushback != null) {
            Character save = (Character)this.pushback;
            this.pushback = null;
            return save;
        }
        if (this.input == null) {
            return null;
        }
        if (this.input.length() == 0) {
            return null;
        }
        if (this.index >= this.input.length()) {
            return null;
        }
        return Character.valueOf(this.input.charAt(this.index++));
    }

    @Override
    public Character nextHex() {
        Character c = this.next();
        if (c == null) {
            return null;
        }
        if (PushbackString.isHexDigit(c)) {
            return c;
        }
        return null;
    }

    @Override
    public Character nextOctal() {
        Character c = this.next();
        if (c == null) {
            return null;
        }
        if (PushbackString.isOctalDigit(c)) {
            return c;
        }
        return null;
    }

    public static boolean isHexDigit(Character c) {
        if (c == null) {
            return false;
        }
        char ch = c.charValue();
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    public static boolean isOctalDigit(Character c) {
        if (c == null) {
            return false;
        }
        char ch = c.charValue();
        return ch >= '0' && ch <= '7';
    }

    @Override
    public Character peek() {
        if (this.pushback != null) {
            return (Character)this.pushback;
        }
        if (this.input == null) {
            return null;
        }
        if (this.input.length() == 0) {
            return null;
        }
        if (this.index >= this.input.length()) {
            return null;
        }
        return Character.valueOf(this.input.charAt(this.index));
    }

    @Override
    public boolean peek(Character c) {
        if (this.pushback != null && ((Character)this.pushback).charValue() == c.charValue()) {
            return true;
        }
        if (this.input == null) {
            return false;
        }
        if (this.input.length() == 0) {
            return false;
        }
        if (this.index >= this.input.length()) {
            return false;
        }
        return this.input.charAt(this.index) == c.charValue();
    }

    @Override
    public void mark() {
        this.temp = this.pushback;
        this.mark = this.index;
    }

    @Override
    public void reset() {
        this.pushback = this.temp;
        this.index = this.mark;
    }

    @Override
    public String remainder() {
        String output = this.input.substring(this.index);
        if (this.pushback != null) {
            output = this.pushback + output;
        }
        return output;
    }
}

