/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.codecs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    public static <T> Collection<T> removeNull(Collection<T> source) {
        if (CollectionUtils.isEmpty(source)) {
            return source;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T value : source) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <T> List<T> distinct(List<T> source) {
        if (source == null || CollectionUtils.isEmpty(source)) {
            return source;
        }
        HashSet<T> set = new HashSet<T>();
        for (T value : source) {
            if (value == null) continue;
            if (value instanceof String) {
                if (!StringUtils.isNotEmpty((CharSequence)((String)value))) continue;
                set.add(value);
                continue;
            }
            set.add(value);
        }
        return new ArrayList(set);
    }

    public static List<String> toUpperCase(List<String> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (String item : list) {
            if (!StringUtils.isNotEmpty((CharSequence)item)) continue;
            newList.add(item.toUpperCase());
        }
        return newList;
    }

    public static Set<Character> arrayToUnmodifiableSet(char ... array) {
        if (array == null) {
            return Collections.emptySet();
        }
        if (array.length == 1) {
            return Collections.singleton(Character.valueOf(array[0]));
        }
        return Collections.unmodifiableSet(CollectionUtils.arrayToSet(array));
    }

    public static Set<Character> strToUnmodifiableSet(String str) {
        if (str == null) {
            return Collections.emptySet();
        }
        if (str.length() == 1) {
            return Collections.singleton(Character.valueOf(str.charAt(0)));
        }
        return Collections.unmodifiableSet(CollectionUtils.strToSet(str));
    }

    public static Set<Character> arrayToSet(char ... array) {
        if (array == null) {
            return new HashSet<Character>();
        }
        HashSet<Character> toReturn = new HashSet<Character>(array.length);
        for (char c : array) {
            toReturn.add(Character.valueOf(c));
        }
        return toReturn;
    }

    public static Set<Character> strToSet(String str) {
        if (str == null) {
            return new HashSet<Character>();
        }
        HashSet<Character> set = new HashSet<Character>(str.length());
        for (int i = 0; i < str.length(); ++i) {
            set.add(Character.valueOf(str.charAt(i)));
        }
        return set;
    }
}

