/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConnectionClient {
    protected static Logger logger = LoggerFactory.getLogger(URLConnectionClient.class);

    public Map<String, Object> executeBase(String requestLocationUri, Map<String, String> requestHeaders, String requestBody, Map<String, String> headers, String requestMethod) throws RuntimeException {
        HashMap map = Maps.newHashMap();
        InputStream responseBody = null;
        URLConnection c = null;
        Map<Object, Object> responseHeaders = new HashMap();
        try {
            URL url = new URL(requestLocationUri);
            c = url.openConnection();
            int responseCode = -1;
            if (c instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)c;
                if (headers != null && !headers.isEmpty()) {
                    for (Map.Entry<String, String> header : headers.entrySet()) {
                        httpURLConnection.addRequestProperty(header.getKey(), header.getValue());
                    }
                }
                if (requestHeaders != null) {
                    for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
                        httpURLConnection.addRequestProperty(header.getKey(), header.getValue());
                    }
                }
                if (StringUtils.isEmpty((CharSequence)requestMethod)) {
                    httpURLConnection.setRequestMethod("GET");
                } else {
                    httpURLConnection.setRequestMethod(requestMethod);
                    this.setRequestBody(requestBody, requestMethod, httpURLConnection);
                }
                httpURLConnection.connect();
                responseCode = httpURLConnection.getResponseCode();
                InputStream inputStream = responseCode == 400 || responseCode == 401 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                responseHeaders = httpURLConnection.getHeaderFields();
                responseBody = inputStream;
                map.put("responseBodyBytes", IOUtils.toByteArray((InputStream)responseBody));
                map.put("contentType", c.getContentType());
                map.put("responseCode", responseCode);
                map.put("responseHeaders", responseHeaders);
            }
            HashMap hashMap = map;
            return hashMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).disconnect();
            }
            if (responseBody != null) {
                try {
                    responseBody.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setRequestBody(String requestBody, String requestMethod, HttpURLConnection httpURLConnection) throws IOException {
        if (StringUtils.isEmpty((CharSequence)requestBody)) {
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)requestMethod, (CharSequence[])new CharSequence[]{"POST", "PUT"})) {
            String encoding = httpURLConnection.getContentEncoding() != null ? httpURLConnection.getContentEncoding() : "UTF-8";
            httpURLConnection.setDoOutput(true);
            OutputStream ost = httpURLConnection.getOutputStream();
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(ost, encoding));){
                pw.print(requestBody);
                pw.flush();
            }
        }
    }
}

