/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.openapi.filter.BodyReaderHttpServletRequestWrapper;
import eu.bitwalker.useragentutils.Browser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;

public class HttpServletUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletUtil.class);

    public static String getIP(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    public static String getCharacterEncoding(HttpServletRequest request) {
        return request.getCharacterEncoding();
    }

    public static String getContentType(HttpServletRequest request) {
        return request.getContentType();
    }

    public static Enumeration<String> getParameterNames(HttpServletRequest request) {
        return request.getParameterNames();
    }

    public static Enumeration<String> getHeaderNames(HttpServletRequest request) {
        return request.getHeaderNames();
    }

    public static Enumeration<String> getHeaders(HttpServletRequest request, String name) {
        return request.getHeaders(name);
    }

    public static String getHeader(HttpServletRequest request, String name) {
        return request.getHeader(name);
    }

    public static String getParameter(HttpServletRequest request, String name) {
        return request.getParameter(name);
    }

    public static String[] getParameterValues(HttpServletRequest request, String name) {
        return request.getParameterValues(name);
    }

    public static Object getAttribute(HttpServletRequest request, String name) {
        return request.getAttribute(name);
    }

    public static String getBodyString(BodyReaderHttpServletRequestWrapper bodyRequest) {
        return bodyRequest.getBodyString();
    }

    public static void setContentType(HttpServletResponse response, String type) {
        response.setContentType(type);
    }

    public static void setContentLength(HttpServletResponse response, int len) {
        response.setContentLength(len);
    }

    public static void setCharacterEncoding(HttpServletResponse response, String charset) {
        response.setCharacterEncoding(charset);
    }

    public static void addHeader(HttpServletResponse response, String name, String value) {
        response.addHeader(name, value);
    }

    public static void addHeader(HttpRequest request, String headerName, String headerValue) {
        request.getHeaders().add(headerName, headerValue);
    }

    public static void setHeader(HttpHeaders httpHeaders, String headerName, String headerValue) {
        if (httpHeaders != null) {
            httpHeaders.set(headerName, headerValue);
        }
    }

    public static void putAllHeader(HttpHeaders httpHeaders, HttpHeaders httpHeaders_) {
        if (httpHeaders != null) {
            httpHeaders.putAll((Map)httpHeaders_);
        }
    }

    public static void setHeader(HttpServletResponse response, String name, String value) {
        response.setHeader(name, value);
    }

    public static void sendError(HttpServletResponse response, int sc) throws IOException {
        response.sendError(sc);
    }

    public static void setDateHeader(HttpServletResponse response, String name, long value) {
        response.setDateHeader(name, value);
    }

    public static void setStatus(HttpServletResponse response, int sc) {
        response.setStatus(sc);
    }

    public static PrintWriter getPrintWriter(HttpServletResponse response) throws IOException {
        return response.getWriter();
    }

    public static void print(HttpServletResponse response, String content) {
        try {
            response.getWriter().print(content);
        }
        catch (IOException e) {
            logger.warn("response.getWriter()\u53d1\u751f\u65f6IOException\u5f02\u5e38!");
        }
    }

    public static void responseError(HttpServletResponse response, Map<Integer, String> errorMap, Integer errorCode) {
        HttpServletUtil.setCharacterEncoding(response, "UTF-8");
        HttpServletUtil.setContentType(response, "text/html; charset=UTF-8");
        HttpServletUtil.setHeader(response, "Strict-Transport-Security", "max-age=31536000; includeSubDomains;preload");
        try {
            String error = errorMap.get(errorCode);
            PrintWriter printWriter = response.getWriter();
            printWriter.print(error == null ? "\u672a\u77e5\u9519\u8bef" : error);
        }
        catch (IOException e) {
            logger.error("PrintWriter\u53d1\u751fIO\u5f02\u5e38");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFileRanges(HttpServletRequest request, HttpServletResponse response, Long fileSize, String fileName, String contentType, InputStream in) throws IOException {
        String requestRange;
        HttpServletUtil.setContentType(response, contentType);
        String userAgentString = HttpServletUtil.getHeader(request, "User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgentString) && Browser.SAFARI.isInUserAgentString(userAgentString)) {
            HttpServletUtil.addHeader(response, "Content-Disposition", "attachment; filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
        } else {
            HttpServletUtil.addHeader(response, "Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        }
        HttpServletUtil.setHeader(response, "Accept-Ranges", "bytes");
        long pos = 0L;
        long last = fileSize - 1L;
        long sum = 0L;
        long rangLength = last - pos + 1L;
        String safeRequestRange = requestRange = HttpServletUtil.getHeader(request, "Range");
        HttpServletUtil.setStatus(response, 206);
        try {
            String numRang = safeRequestRange.replaceAll("bytes=", "");
            String[] strRange = numRang.split("-");
            if (strRange.length == 2) {
                pos = Long.parseLong(strRange[0].trim());
                last = Long.parseLong(strRange[1].trim());
            } else {
                pos = Long.parseLong(numRang.replaceAll("-", "").trim());
            }
        }
        catch (Exception e) {
            logger.warn("Range\u6807\u5934\u4e0d\u662f\u6570\u5b57!");
            pos = 0L;
        }
        String contentRange = new StringBuffer("bytes ").append(pos).append("-").append(last).append("/").append(fileSize).toString();
        HttpServletUtil.setHeader(response, "Content-Range", contentRange);
        HttpServletUtil.addHeader(response, "Content-Length", String.valueOf(rangLength));
        BufferedInputStream inputStream = null;
        BufferedOutputStream bufferOut = null;
        try {
            bufferOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            inputStream = new BufferedInputStream(in);
            ((InputStream)inputStream).skip(pos);
            byte[] buffer = new byte[1024];
            long length = 0L;
            while (sum < rangLength) {
                length = ((InputStream)inputStream).read(buffer, 0, rangLength - sum <= (long)buffer.length ? (int)(rangLength - sum) : buffer.length);
                sum += length;
                if (length < Integer.MAX_VALUE) {
                    ((OutputStream)bufferOut).write(buffer, 0, (int)length);
                    continue;
                }
                throw new IOException("\u6587\u4ef6\u8fc7\u5927\u65e0\u6cd5\u4e0b\u8f7d");
            }
        }
        catch (Exception e) {
            try {
                if (!(e instanceof ClientAbortException)) {
                    logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25...");
                    throw new IOException(e);
                }
                logger.info("\u7528\u6237\u53d6\u6d88\u4e0b\u8f7d!");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferOut);
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)bufferOut);
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((OutputStream)bufferOut);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)in);
    }
}

