/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileZipUtils {
    protected static Logger logger = LoggerFactory.getLogger(FileZipUtils.class);

    public static File compress(File sourceFile, String password) {
        String fileName = sourceFile.getName();
        String realName = fileName.indexOf(".") != -1 ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
        File targetFile = new File(sourceFile.getParent() + File.separator + realName + ".zip");
        ZipParameters zipParameters = new ZipParameters();
        ZipFile zipFile = new ZipFile(targetFile);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            zipParameters.setEncryptFiles(true);
            zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
            zipFile.setPassword(password.toCharArray());
        }
        try {
            if (sourceFile.isDirectory()) {
                File[] files;
                for (File file : files = sourceFile.listFiles()) {
                    if (file.isDirectory()) {
                        zipFile.addFolder(file, zipParameters);
                        continue;
                    }
                    zipFile.addFile(file, zipParameters);
                }
            } else {
                zipFile.addFile(sourceFile, zipParameters);
            }
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return targetFile;
    }

    public static void uncompress(File sourceFile, File targetDir, String password) {
        if (!FileUtil.exists(targetDir)) {
            targetDir.mkdir();
        }
        ZipFile zipFile = new ZipFile(sourceFile);
        try {
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password.toCharArray());
            }
            zipFile.extractAll(targetDir.getPath());
        }
        catch (ZipException e) {
            logger.error("\u89e3\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

