/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

public class FileUtil
extends FileUtils {
    public static File newFile(String pathname) {
        return new File(pathname);
    }

    public static File newFile(String parent, String child) {
        FileUtil.mkdirs(parent);
        return new File(parent, child);
    }

    public static File newFile(File parent, String child) {
        FileUtil.mkdirs(parent);
        return new File(parent, child);
    }

    public static boolean mkdirs(File file) {
        if (!FileUtil.exists(file)) {
            return file.mkdirs();
        }
        return false;
    }

    public static boolean mkdirs(String pathname) {
        return FileUtil.newFile(pathname).mkdirs();
    }

    public static boolean mkdir(File file) {
        return file.mkdir();
    }

    public static boolean mkdir(String pathname) {
        return FileUtil.newFile(pathname).mkdir();
    }

    public static File[] listFiles(File searchFile, FileFilter filter) {
        return searchFile.listFiles(filter);
    }

    public static File[] listFiles(File searchFile, FilenameFilter filter) {
        return searchFile.listFiles(filter);
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static boolean exists(String pathname) {
        return FileUtil.newFile(pathname).exists();
    }

    public static boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public static boolean isFile(File file) {
        return file.isFile();
    }

    public static boolean canRead(String pathname) {
        return FileUtil.newFile(pathname).canRead();
    }

    public static boolean canWrite(String pathname) {
        return FileUtil.newFile(pathname).canWrite();
    }

    public static boolean canExecute(String pathname) {
        return FileUtil.newFile(pathname).canExecute();
    }

    public static boolean canRead(File file) {
        return file.canRead();
    }

    public static boolean canWrite(File file) {
        return file.canWrite();
    }

    public static boolean canExecute(File file) {
        return file.canExecute();
    }

    public static String getParent(String pathname) {
        return FileUtil.newFile(pathname).getParent();
    }

    public static String getName(String pathname) {
        return FileUtil.newFile(pathname).getName();
    }

    public static String getAbsolutePath(String pathname) {
        return FileUtil.newFile(pathname).getAbsolutePath();
    }

    public static long length(String pathname) {
        return FileUtil.newFile(pathname).length();
    }

    public static String getPath(String parent, String child) {
        return FileUtil.newFile(parent, child).getPath();
    }

    public static String readFileContent(String pathname) throws IOException {
        StringBuilder sb = new StringBuilder();
        List list = FileUtils.readLines((File)FileUtil.newFile(pathname), (String)"UTF-8");
        list.forEach(line -> sb.append((String)line).append(System.getProperty("line.separator")));
        return sb.toString();
    }

    public static void writeFileContent(String pathname, String content) throws IOException {
        FileUtils.write((File)FileUtil.newFile(pathname), (CharSequence)content, (String)"UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream in, String pathname) throws IOException {
        try (FileOutputStream out = new FileOutputStream(pathname);){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static int copy(String inPathname, String outPathname) throws IOException {
        return FileCopyUtils.copy((File)FileUtil.newFile(inPathname), (File)FileUtil.newFile(outPathname));
    }

    public static int copy(InputStream in, String outPathname) throws IOException {
        return FileCopyUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(outPathname));
    }

    public static String getFilenameFromPath(String path) {
        String firstPathCandidate = path.substring(path.lastIndexOf("/") + 1);
        String secondPathCandidate = path.substring(path.lastIndexOf("\\") + 1);
        return path.equals(firstPathCandidate) ? secondPathCandidate : firstPathCandidate;
    }

    public static boolean createDir(File dir) {
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }
}

