/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.openapi.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyReaderHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private byte[] buffer = null;

    public BodyReaderHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.copyInputStream();
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer != null ? Arrays.copyOf(buffer, buffer.length) : null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.buffer != null) {
            return new BodyReaderBufferInputStream(this.buffer);
        }
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.readCharacterEncoding((HttpServletRequest)this)));
    }

    public String getBodyString() {
        String bodyString = null;
        try {
            bodyString = new String(this.buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("buffer\u8f6c\u5b57\u7b26\u4e32\u53d1\u751fUnsupportedEncodingException");
        }
        return bodyString;
    }

    public void copyInputStream() throws IOException {
        ServletInputStream is = null;
        try {
            is = super.getInputStream();
            if (is != null) {
                this.buffer = IOUtils.toByteArray((InputStream)is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error("InputStream\u5173\u95ed\u5f02\u5e38");
                }
            }
        }
    }

    public Charset readCharacterEncoding(HttpServletRequest request) {
        Charset charset = null;
        String characterEncoding = request.getCharacterEncoding();
        charset = StringUtils.isNotBlank((CharSequence)characterEncoding) && !StringUtils.equalsIgnoreCase((CharSequence)characterEncoding, (CharSequence)"null") ? Charset.forName(characterEncoding) : Charset.defaultCharset();
        return charset;
    }

    private class BodyReaderBufferInputStream
    extends ServletInputStream {
        private ByteArrayInputStream inputStream;

        public BodyReaderBufferInputStream(byte[] buffer) {
            this.inputStream = buffer == null ? null : new ByteArrayInputStream(buffer);
        }

        public int available() throws IOException {
            return this.inputStream.available();
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener listener) {
        }
    }
}

