/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.cache;

import cn.aotcloud.cache.CacheStorage;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MemoryCacheStorage<T>
implements CacheStorage<T> {
    private final Cache<String, T> cache;
    private String prefix;
    private final long expiryTime;

    public MemoryCacheStorage(String prefix, long expiryTime) {
        this.prefix = prefix + ":";
        this.expiryTime = expiryTime;
        this.cache = this.buildCache(this.expiryTime);
    }

    @Override
    public void addCache(String key, T value) {
        this.cache.put((Object)(this.prefix + key), value);
    }

    @Override
    public T getCache(String key) {
        return (T)this.cache.getIfPresent((Object)(this.prefix + key));
    }

    @Override
    public void deleteCache(String key) {
        this.cache.invalidate((Object)(this.prefix + key));
    }

    @Override
    public Set<String> keys() {
        return this.cache.asMap().keySet();
    }

    private Cache<String, T> buildCache(long cacheTime) {
        if (cacheTime < 0L) {
            return CacheBuilder.newBuilder().expireAfterWrite(87600L, TimeUnit.HOURS).build();
        }
        return CacheBuilder.newBuilder().expireAfterWrite(cacheTime, TimeUnit.SECONDS).build();
    }
}

