/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class OAuthSafeUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream is, String defaultCharset) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream may not be null");
        }
        String charset = defaultCharset;
        if (charset == null) {
            charset = "UTF-8";
        }
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(is, charset);){
            int l;
            char[] tmp = new char[4096];
            while ((l = reader.read(tmp)) != -1) {
                sb.append(tmp, 0, l);
            }
        }
        return sb.toString();
    }

    public static Set<String> decodeScopes(String s) {
        HashSet<String> scopes = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)s)) {
            StringTokenizer tokenizer = new StringTokenizer(s, " ");
            while (tokenizer.hasMoreElements()) {
                scopes.add(tokenizer.nextToken());
            }
        }
        return scopes;
    }

    public static String encodeScopes(Set<String> s) {
        StringBuffer scopes = new StringBuffer();
        for (String scope : s) {
            scopes.append(scope).append(" ");
        }
        return scopes.toString().trim();
    }

    public static boolean hasContentType(String requestContentType, String requiredContentType) {
        if (StringUtils.isEmpty((CharSequence)requiredContentType) || StringUtils.isEmpty((CharSequence)requestContentType)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(requestContentType, ";");
        while (tokenizer.hasMoreTokens()) {
            if (!requiredContentType.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

