/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;

public class CodecUtils {
    protected static final Logger logger = LoggerFactory.getLogger(CodecUtils.class);

    public static String getMd5HexString(InputStream data) {
        try {
            return DigestUtils.md5Hex((InputStream)data);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6Md5\u7f16\u7801\u65f6IOException\u5f02\u5e38");
            return null;
        }
    }

    public static String getSha1HexString(InputStream data) {
        try {
            return DigestUtils.sha1Hex((InputStream)data);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6Sha1\u7f16\u7801\u65f6IOException\u5f02\u5e38");
            return null;
        }
    }

    public static ByteArrayInputStream stringToInputStream(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public static HttpInputMessage createHttpInputMessage(final HttpHeaders httpHeaders, String data) {
        final byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new HttpInputMessage(){

            public HttpHeaders getHeaders() {
                httpHeaders.setContentLength((long)bytes.length);
                return httpHeaders;
            }

            public InputStream getBody() {
                return inputStream;
            }
        };
    }
}

