/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.cache;

import cn.aotcloud.cache.CacheStorage;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;

public class RedisCacheStorage<T>
implements CacheStorage<T> {
    private final RedisOperations<String, T> redisOperations;
    private String prefix;
    private final Long expiryTime;

    public RedisCacheStorage(RedisConnectionFactory connectionFactory, String prefix, long expiryTime) {
        this.redisOperations = this.createDefaultTemplate(connectionFactory);
        this.prefix = prefix + ":";
        this.expiryTime = expiryTime;
    }

    private RedisTemplate<String, T> createDefaultTemplate(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory cannot be null");
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory(connectionFactory);
        template.afterPropertiesSet();
        return template;
    }

    @Override
    public void addCache(String key, T value) {
        if (this.expiryTime < 0L) {
            this.redisOperations.opsForValue().set((Object)(this.prefix + key), value, 87600L, TimeUnit.HOURS);
        } else {
            this.redisOperations.opsForValue().set((Object)(this.prefix + key), value, this.expiryTime.longValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public T getCache(String key) {
        return (T)this.redisOperations.opsForValue().get((Object)(this.prefix + key));
    }

    @Override
    public void deleteCache(String key) {
        this.redisOperations.delete((Object)(this.prefix + key));
    }

    @Override
    public Set<String> keys() {
        return this.redisOperations.keys((Object)(this.prefix + "*"));
    }
}

