/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.tamperproofing;

import cn.aotcloud.security.tamperproofing.HttpRequestMatcher;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class SimpleHttpRequestMatcher
implements HttpRequestMatcher {
    private final PathMatcher pathMatcher;
    private final UrlPathHelper urlPathHelper;

    public SimpleHttpRequestMatcher() {
        this(null, null);
    }

    public SimpleHttpRequestMatcher(PathMatcher pathMatcher, UrlPathHelper urlPathHelper) {
        this.pathMatcher = pathMatcher != null ? pathMatcher : new AntPathMatcher();
        this.urlPathHelper = urlPathHelper != null ? urlPathHelper : new UrlPathHelper();
    }

    @Override
    public boolean match(List<String> patterns, HttpServletRequest request) {
        String requestUri = this.getUrlPathHelper().getLookupPathForRequest(request);
        return this.match(patterns, requestUri);
    }

    @Override
    public boolean match(List<String> patterns, String path) {
        return patterns.stream().anyMatch(pattern -> this.match((String)pattern, path));
    }

    @Override
    public boolean match(String pattern, HttpServletRequest request) {
        String requestUri = this.getUrlPathHelper().getLookupPathForRequest(request);
        return this.match(pattern, requestUri);
    }

    @Override
    public boolean match(String pattern, String path) {
        return this.getPathMatcher().match(pattern.trim(), path);
    }

    @Override
    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }
}

