/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport.http.json;

import cn.aotcloud.security.transport.CryptoMediaType;
import cn.aotcloud.security.transport.HttpCryptoSm4Certificate;
import cn.aotcloud.security.transport.Sm4KeyHolder;
import cn.aotcloud.utils.HttpRequestUtil;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UrlPathHelper;

@Order(value=1)
public class CryptoHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private final MappingJackson2HttpMessageConverter jacksonConverter;
    private final StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private List<String> urls = Lists.newArrayList();
    private boolean urlExclude = true;

    public CryptoHttpMessageConverter(MappingJackson2HttpMessageConverter jacksonConverter, List<String> urls, boolean urlExclude) {
        this.jacksonConverter = jacksonConverter;
        this.urls.addAll(urls);
        this.urlExclude = urlExclude;
    }

    protected boolean supports(Class<?> clazz) {
        if (HttpRequestUtil.getHttpServletRequestFromThreadLocal() == null) {
            return false;
        }
        return this.shouldCrypto(HttpRequestUtil.getHttpServletRequestFromThreadLocal());
    }

    public boolean shouldCrypto(HttpServletRequest request) {
        String requestUri = this.urlPathHelper.getLookupPathForRequest(request);
        return this.shouldCrypto(requestUri);
    }

    private boolean shouldCrypto(String url) {
        if (this.urlExclude) {
            return !this.doPtternUri(url);
        }
        return this.doPtternUri(url);
    }

    private boolean doPtternUri(String uri) {
        for (String pattern : this.urls) {
            if (!this.antPathMatcher.match(pattern, uri)) continue;
            return true;
        }
        return false;
    }

    protected boolean canWrite(MediaType mediaType) {
        return true;
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return null;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(CryptoMediaType.APPLICATION_SM4_PUBLIC_JSON_UTF8);
    }

    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        String responseJsonText = o instanceof String ? (String)o : this.jacksonConverter.getObjectMapper().writeValueAsString(o);
        HttpCryptoSm4Certificate httpCryptoSm4Certificate = StringUtils.isEmpty((CharSequence)Sm4KeyHolder.getSm4Key()) && StringUtils.isEmpty((CharSequence)Sm4KeyHolder.getSm4Iv()) ? new HttpCryptoSm4Certificate() : new HttpCryptoSm4Certificate(Sm4KeyHolder.getSm4Key(), Sm4KeyHolder.getSm4Iv());
        outputMessage.getHeaders().set("X-AC-ENCRYPTO", "true");
        String encryptedResponseText = httpCryptoSm4Certificate.getTextEncryptor().encrypt(responseJsonText);
        this.stringHttpMessageConverter.write((Object)encryptedResponseText, CryptoMediaType.APPLICATION_SM4_PUBLIC_JSON_UTF8, outputMessage);
    }
}

