/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support.simple;

import cn.aotcloud.crypto.pcode.PcodeEncoder;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.security.oncetoken.OnceProtocol;
import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenStore;
import cn.aotcloud.security.oncetoken.RequestTokenValidator;
import org.apache.commons.lang3.StringUtils;

public class SimpleRequestTokenValidator
implements RequestTokenValidator {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());
    protected final RequestTokenStore requestTokenStore;
    protected final PcodeEncoder pscodeEncoder;
    protected final long timeinterval;
    protected final String requestTokenSalt;

    public SimpleRequestTokenValidator(RequestTokenStore requestTokenStore, PcodeEncoder pscodeEncoder, long timeinterval, String requestTokenSalt) {
        this.requestTokenStore = requestTokenStore;
        this.pscodeEncoder = pscodeEncoder;
        this.timeinterval = timeinterval;
        this.requestTokenSalt = requestTokenSalt;
    }

    @Override
    public boolean support(RequestToken requestToken) {
        return requestToken != null && (StringUtils.isBlank((CharSequence)requestToken.getProtocol()) || StringUtils.equalsIgnoreCase((CharSequence)requestToken.getProtocol(), (CharSequence)OnceProtocol.simple.name()));
    }

    @Override
    public boolean validate(RequestToken requestToken) {
        return requestToken != null && this.isValidTimestamp(requestToken.getCreateTime()) && this.isValidNonce(requestToken.getToken()) && this.isValidSign(requestToken);
    }

    protected boolean isValidTimestamp(Long timestamp) {
        boolean flag;
        boolean bl = flag = timestamp != null && Math.abs(System.currentTimeMillis() - timestamp) <= this.timeinterval;
        if (!flag) {
            this.logger.error("\u8bf7\u6c42\u4ee4\u724c\u65f6\u95f4\u6233\u4e0d\u5408\u6cd5\u3002");
        }
        return flag;
    }

    protected boolean isValidNonce(String nonce) {
        boolean flag;
        RequestToken requestTokenFromDb = this.requestTokenStore.getToken(nonce);
        boolean bl = flag = StringUtils.isNotBlank((CharSequence)nonce) && (requestTokenFromDb == null || requestTokenFromDb.isExpired());
        if (!flag) {
            this.logger.error("\u8bf7\u6c42\u4ee4\u724c\u968f\u673a\u6570\u4e0d\u5408\u6cd5\u3002");
        }
        return flag;
    }

    protected boolean isValidSign(RequestToken requestTokenFromRequest) {
        boolean flag = this.pscodeEncoder.matches((CharSequence)this.getRequestTokenAsStr(requestTokenFromRequest), requestTokenFromRequest.getSign());
        if (!flag) {
            this.logger.error("\u8bf7\u6c42\u4ee4\u724c\u7b7e\u540d\u6458\u8981\u4e0d\u5408\u6cd5\u3002");
        }
        return flag;
    }

    protected String getRequestTokenAsStr(RequestToken requestTokenFromRequest) {
        return String.join((CharSequence)",", requestTokenFromRequest.getCreateTime().toString(), requestTokenFromRequest.getToken());
    }
}

