/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support;

import cn.aotcloud.security.oncetoken.OnceProtocol;
import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenParser;
import cn.aotcloud.security.oncetoken.support.once2.Once2RequestTokenParser;
import cn.aotcloud.security.oncetoken.support.simple.SimpleRequestTokenParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.CollectionUtils;

public class DelegateRequestTokenParser
implements RequestTokenParser {
    private Map<OnceProtocol, RequestTokenParser> requestTokenParsers = new LinkedHashMap<OnceProtocol, RequestTokenParser>();
    private List<OnceProtocol> supportedProtocols;

    public DelegateRequestTokenParser(List<OnceProtocol> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        this.requestTokenParsers.put(OnceProtocol.once2, new Once2RequestTokenParser());
        this.requestTokenParsers.put(OnceProtocol.simple, new SimpleRequestTokenParser());
    }

    @Override
    public RequestToken parse(HttpServletRequest request) {
        if (CollectionUtils.isEmpty(this.supportedProtocols)) {
            for (RequestTokenParser requestTokenParser : this.requestTokenParsers.values()) {
                RequestToken requestToken = requestTokenParser.parse(request);
                if (requestToken == null) continue;
                return requestToken;
            }
        } else {
            for (OnceProtocol protocol : this.supportedProtocols) {
                RequestToken requestToken;
                RequestTokenParser requestTokenParser = this.requestTokenParsers.get((Object)protocol);
                if (requestTokenParser == null || (requestToken = requestTokenParser.parse(request)) == null) continue;
                return requestToken;
            }
        }
        return null;
    }
}

