/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport.support;

import cn.aotcloud.security.transport.CryptoHttpInputMessage;
import cn.aotcloud.security.transport.HttpCryptoSm2Certificate;
import cn.aotcloud.security.transport.support.QueryParamsRequestDecryptor;
import cn.aotcloud.utils.HttpServletUtil;
import cn.aotcloud.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class FormRequestDecryptor
extends QueryParamsRequestDecryptor {
    private static final String FORM_ATTR_CRYPTO_DATA = "x_ac_form_attr_crypto_data";
    private AllEncompassingFormHttpMessageConverter formHttpMessageConverter;

    public FormRequestDecryptor(HttpCryptoSm2Certificate httpCryptoSm2Certificate, AllEncompassingFormHttpMessageConverter formHttpMessageConverter) {
        super(httpCryptoSm2Certificate);
        this.formHttpMessageConverter = formHttpMessageConverter;
    }

    @Override
    public boolean support(HttpInputMessage inputMessage) {
        if (inputMessage instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest httpRequest = (ServletServerHttpRequest)inputMessage;
            return httpRequest.getMethod().matches(HttpMethod.POST.name()) && this.isFormAndMultipart(inputMessage.getHeaders().getContentType()) && StringUtils.isNotBlank((CharSequence)HttpServletUtil.getParameter((HttpServletRequest)httpRequest.getServletRequest(), (String)FORM_ATTR_CRYPTO_DATA));
        }
        return false;
    }

    protected boolean isFormAndMultipart(MediaType contentType) {
        return contentType != null && (contentType.includes(MediaType.APPLICATION_FORM_URLENCODED) || contentType.includes(MediaType.MULTIPART_FORM_DATA));
    }

    @Override
    public CryptoHttpInputMessage doDecrypt(HttpInputMessage inputMessage) throws IOException {
        CryptoHttpInputMessage cryptoHttpInputMessage = super.support(inputMessage) ? super.doDecrypt(inputMessage) : new CryptoHttpInputMessage();
        ServletServerHttpRequest httpRequest = (ServletServerHttpRequest)inputMessage;
        String encryptedData = HttpServletUtil.getParameter((HttpServletRequest)httpRequest.getServletRequest(), (String)FORM_ATTR_CRYPTO_DATA);
        this.setSm4KeyHolder(encryptedData);
        ByteArrayHttpOutputMessage outputMessage = new ByteArrayHttpOutputMessage(httpRequest);
        ByteArrayOutputStream baos = (ByteArrayOutputStream)outputMessage.getBody();
        byte[] bytes = baos.toByteArray();
        cryptoHttpInputMessage.setBody(bytes);
        IOUtils.closeQuietly((OutputStream)baos);
        return cryptoHttpInputMessage;
    }

    protected MultiValueMap<String, ?> parseDecryptedData(Map<String, Object> decryptedData) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        for (String key : decryptedData.keySet()) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            tmp.add(decryptedData.get(key));
            form.put((Object)key, tmp);
        }
        return form;
    }

    public AllEncompassingFormHttpMessageConverter getFormHttpMessageConverter() {
        return this.formHttpMessageConverter;
    }

    private static class ByteArrayHttpOutputMessage
    implements HttpOutputMessage {
        ServletServerHttpRequest request;
        private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public ByteArrayHttpOutputMessage(ServletServerHttpRequest request) {
            this.request = request;
        }

        public OutputStream getBody() throws IOException {
            return this.outputStream;
        }

        public HttpHeaders getHeaders() {
            return this.request.getHeaders();
        }
    }
}

