/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class CryptoHttpInputMessage
implements HttpInputMessage {
    private HttpHeaders headers;
    private InputStream body;
    private String queryString;
    private MultiValueMap<String, String> queryParams;

    public CryptoHttpInputMessage() {
    }

    public CryptoHttpInputMessage(InputStream body, HttpHeaders headers) {
        Assert.notNull((Object)body, (String)"InputStream must not be null");
        Assert.notNull((Object)headers, (String)"headers must not be null");
        this.body = body;
        this.headers = headers;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        return this.body;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setBody(InputStream body) {
        this.body = body;
    }

    public void setBody(byte[] contents) {
        this.body = new ByteArrayInputStream(contents != null ? contents : new byte[]{});
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        this.queryParams = UriComponentsBuilder.fromUriString((String)"http://localhost/").query(queryString).build().getQueryParams();
    }

    public MultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }
}

