/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport;

import cn.aotcloud.exception.BaseException;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.security.transport.CryptoHttpInputMessage;
import cn.aotcloud.security.transport.HttpCryptoSm2Certificate;
import cn.aotcloud.security.transport.HttpCryptoSm4Certificate;
import cn.aotcloud.security.transport.HttpTextEncryptor;
import cn.aotcloud.security.transport.RequestDecryptor;
import cn.aotcloud.security.transport.Sm4KeyHolder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public abstract class AbstractRequestDecryptor
extends HttpTextEncryptor
implements RequestDecryptor {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());

    public AbstractRequestDecryptor(HttpCryptoSm2Certificate sm2Key) {
        super(sm2Key);
    }

    @Override
    public String getDescription() {
        return this.getTextEncryptor().getClass().getSimpleName() + "/" + this.getTextEncryptor().getClass().getSimpleName();
    }

    @Override
    public boolean support(HttpInputMessage inputMessage) {
        return true;
    }

    @Override
    public final CryptoHttpInputMessage decrypt(HttpInputMessage inputMessage) throws IOException {
        return this.doDecrypt(inputMessage);
    }

    public abstract CryptoHttpInputMessage doDecrypt(HttpInputMessage var1) throws IOException;

    protected String decryptData(String data) {
        String[] certificate = data.split("AAAA0000BBBB");
        if (certificate.length != 3 || StringUtils.isEmpty((CharSequence)certificate[0]) || StringUtils.isEmpty((CharSequence)certificate[1]) || StringUtils.isEmpty((CharSequence)certificate[2])) {
            throw new BaseException("\u6570\u636e\u5b8c\u6574\u6027\u88ab\u7834\u574f\u3002");
        }
        String encryptedSm4RequestData = certificate[0];
        String sm4Key = this.getTextEncryptor().decrypt(certificate[1]);
        String sm4Iv = this.getTextEncryptor().decrypt(certificate[2]);
        Sm4KeyHolder.setSm4Key(sm4Key);
        Sm4KeyHolder.setSm4Iv(sm4Iv);
        TextEncryptor sm4TextEncryptor = new HttpCryptoSm4Certificate(sm4Key, sm4Iv).getTextEncryptor();
        return sm4TextEncryptor.decrypt(encryptedSm4RequestData);
    }

    protected void setSm4KeyHolder(String data) {
        String[] certificate = data.split("AAAA0000BBBB");
        if (certificate.length != 3 || StringUtils.isEmpty((CharSequence)certificate[0]) || StringUtils.isEmpty((CharSequence)certificate[1]) || StringUtils.isEmpty((CharSequence)certificate[2])) {
            throw new BaseException("\u6570\u636e\u5b8c\u6574\u6027\u88ab\u7834\u574f\u3002");
        }
        String sm4Key = this.getTextEncryptor().decrypt(certificate[1]);
        String sm4Iv = this.getTextEncryptor().decrypt(certificate[2]);
        Sm4KeyHolder.setSm4Key(sm4Key);
        Sm4KeyHolder.setSm4Iv(sm4Iv);
    }

    protected Charset getCharset(HttpInputMessage inputMessage) {
        MediaType mediaType = inputMessage.getHeaders().getContentType();
        Charset charset = mediaType.getCharset();
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return charset;
    }
}

