/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.tamperproofing.impl;

import cn.aotcloud.security.tamperproofing.AbstractTamperProofingChecker;
import cn.aotcloud.security.tamperproofing.SafeException;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class GetQueryTamperProofingChecker
extends AbstractTamperProofingChecker {
    public GetQueryTamperProofingChecker(TextEncryptor textEncryptor) {
        super(textEncryptor);
    }

    @Override
    public boolean support(HttpServletRequest request) {
        return this.isGetQueryRequest(request) && !this.isRootRequest(request) && !this.isIgwClientRequest(request);
    }

    protected boolean isGetQueryRequest(HttpServletRequest request) {
        return StringUtils.equalsIgnoreCase((CharSequence)"GET", (CharSequence)request.getMethod()) && StringUtils.isNotBlank((CharSequence)HttpServletUtil.getQueryString((HttpServletRequest)request));
    }

    protected boolean isRootRequest(HttpServletRequest request) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)request.getServletPath(), (CharSequence[])new CharSequence[]{"/", ""});
    }

    protected boolean isIgwClientRequest(HttpServletRequest request) {
        return StringUtils.equalsIgnoreCase((CharSequence)"/", (CharSequence)request.getServletPath()) && StringUtils.containsAnyIgnoreCase((CharSequence)HttpServletUtil.getQueryString((HttpServletRequest)request), (CharSequence[])new CharSequence[]{"version=", "platform="});
    }

    @Override
    public void check(HttpServletRequest request) throws SafeException {
        String data = this.sortQueryString(request);
        this.doValdiate(request, data, this.getSignValue(request));
    }

    protected String sortQueryString(HttpServletRequest request) {
        String queryString = HttpServletUtil.getQueryString((HttpServletRequest)request);
        if (StringUtils.contains((CharSequence)queryString, (CharSequence)"&")) {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            if (StringUtils.isNotBlank((CharSequence)queryString)) {
                String[] items;
                for (String item : items = queryString.split("&")) {
                    if (!StringUtils.contains((CharSequence)item, (CharSequence)"=")) continue;
                    queryParams.add((Object)StringUtils.substringBefore((String)item, (String)"="), (Object)StringUtils.substringAfter((String)item, (String)"="));
                }
            }
            ArrayList list = new ArrayList(queryParams.keySet());
            Collections.sort(list);
            LinkedMultiValueMap hashMap = new LinkedMultiValueMap();
            list.forEach(arg_0 -> GetQueryTamperProofingChecker.lambda$sortQueryString$0((MultiValueMap)hashMap, (MultiValueMap)queryParams, arg_0));
            queryString = UriComponentsBuilder.fromHttpUrl((String)"http://localhost").queryParams((MultiValueMap)hashMap).build().getQuery();
        }
        return this.urlDecode(queryString);
    }

    protected String urlDecode(String queryString) {
        try {
            return URLDecoder.decode(queryString, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return queryString;
        }
    }

    private static /* synthetic */ void lambda$sortQueryString$0(MultiValueMap hashMap, MultiValueMap queryParams, String key) {
        if (!StringUtils.equals((CharSequence)"X-Ac-Data-Sign", (CharSequence)key)) {
            hashMap.put((Object)key, queryParams.get((Object)key));
        }
    }
}

