/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support;

import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DelegateRequestTokenValidator
implements RequestTokenValidator {
    private List<RequestTokenValidator> requestTokenValidators = new ArrayList<RequestTokenValidator>();

    public DelegateRequestTokenValidator(RequestTokenValidator ... requestTokenValidators) {
        this.requestTokenValidators.addAll(Arrays.asList(requestTokenValidators));
    }

    @Override
    public boolean support(RequestToken requestToken) {
        return true;
    }

    @Override
    public boolean validate(RequestToken requestToken) {
        RequestTokenValidator requestTokenValidator = this.getRequestTokenValidator(requestToken);
        if (requestTokenValidator != null) {
            return requestTokenValidator.validate(requestToken);
        }
        return false;
    }

    protected RequestTokenValidator getRequestTokenValidator(RequestToken requestToken) {
        return this.requestTokenValidators.stream().filter(requestTokenValidator -> requestTokenValidator.support(requestToken)).findFirst().orElse(null);
    }
}

