/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support;

import cn.aotcloud.security.oncetoken.IllegalRequestTokenException;
import cn.aotcloud.security.oncetoken.OnceProtocol;
import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenHandler;
import cn.aotcloud.security.oncetoken.RequestTokenParser;
import cn.aotcloud.security.oncetoken.RequestTokenStore;
import cn.aotcloud.security.oncetoken.RequestTokenValidator;
import cn.aotcloud.security.oncetoken.event.IllegalRequestTokenApplicationEvent;
import cn.aotcloud.security.oncetoken.support.DelegateRequestTokenParser;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class DefaultRequestTokenHandler
implements RequestTokenHandler,
ApplicationEventPublisherAware {
    private RequestTokenStore requestTokenStore;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private ApplicationEventPublisher applicationEventPublisher;
    private RequestTokenParser requestTokenParser;
    private RequestTokenValidator requestTokenValidator;
    private List<OnceProtocol> supportedProtocols;
    private boolean requestTokenEnabled;
    private List<String> urls = Lists.newArrayList();

    public DefaultRequestTokenHandler(RequestTokenStore requestTokenStore, RequestTokenValidator requestTokenValidator, boolean requestTokenEnabled, List<String> urls) {
        this.requestTokenStore = requestTokenStore;
        this.requestTokenValidator = requestTokenValidator;
        this.requestTokenEnabled = requestTokenEnabled;
        this.urls.addAll(urls);
        this.requestTokenParser = new DelegateRequestTokenParser(this.supportedProtocols);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public boolean support(HttpServletRequest request) {
        return this.requestTokenEnabled && this.matchRequest(request);
    }

    protected boolean matchRequest(HttpServletRequest request) {
        String requestUri = this.urlPathHelper.getLookupPathForRequest(request);
        return this.urls.stream().filter(url -> this.pathMatcher.match(url, requestUri)).findAny().isPresent();
    }

    @Override
    public void validate(HttpServletRequest request) throws IllegalRequestTokenException {
        if (this.support(request)) {
            RequestToken requestTokenFromRequest = this.parseRequestToken(request);
            if (requestTokenFromRequest != RequestToken.ILLEGAL_REQUEST_TOKEN && this.requestTokenValidator.validate(requestTokenFromRequest)) {
                this.requestTokenStore.save(requestTokenFromRequest);
            } else {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new IllegalRequestTokenApplicationEvent(requestTokenFromRequest != null ? requestTokenFromRequest : RequestToken.ILLEGAL_REQUEST_TOKEN));
                throw new IllegalRequestTokenException();
            }
        }
    }

    protected RequestToken parseRequestToken(HttpServletRequest request) {
        return this.requestTokenParser.parse(request);
    }
}

