/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport.support;

import cn.aotcloud.security.transport.AbstractRequestDecryptor;
import cn.aotcloud.security.transport.CryptoHttpInputMessage;
import cn.aotcloud.security.transport.HttpCryptoSm2Certificate;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.server.ServletServerHttpRequest;

public class QueryParamsRequestDecryptor
extends AbstractRequestDecryptor {
    public static final String CRYPTO_PARAM_DATA = "x_ac_query_param_crypto_data";

    public QueryParamsRequestDecryptor(HttpCryptoSm2Certificate sm2Key) {
        super(sm2Key);
    }

    @Override
    public boolean support(HttpInputMessage inputMessage) {
        if (inputMessage instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest httpRequest = (ServletServerHttpRequest)inputMessage;
            return StringUtils.isNotBlank((CharSequence)HttpServletUtil.getParameter((HttpServletRequest)httpRequest.getServletRequest(), (String)CRYPTO_PARAM_DATA));
        }
        return false;
    }

    @Override
    public CryptoHttpInputMessage doDecrypt(HttpInputMessage inputMessage) throws IOException {
        CryptoHttpInputMessage cryptoHttpInputMessage = new CryptoHttpInputMessage();
        ServletServerHttpRequest httpRequest = (ServletServerHttpRequest)inputMessage;
        String cryptoData = HttpServletUtil.getParameter((HttpServletRequest)httpRequest.getServletRequest(), (String)CRYPTO_PARAM_DATA);
        if (StringUtils.isNotBlank((CharSequence)cryptoData)) {
            String decryptedData = this.decryptData(cryptoData);
            cryptoHttpInputMessage.setQueryString(decryptedData);
        } else {
            this.logger.warn("\u52a0\u5bc6\u7684\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a\u3002");
        }
        return cryptoHttpInputMessage;
    }
}

