/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport.support;

import cn.aotcloud.security.transport.CryptoHttpInputMessage;
import cn.aotcloud.security.transport.CryptoMediaType;
import cn.aotcloud.security.transport.HttpCryptoSm2Certificate;
import cn.aotcloud.security.transport.support.QueryParamsRequestDecryptor;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;

public class JsonRequestDecryptor
extends QueryParamsRequestDecryptor {
    private StringHttpMessageConverter stringHttpMessageConverter;

    public JsonRequestDecryptor(HttpCryptoSm2Certificate httpCryptoSm2Certificate, StringHttpMessageConverter stringHttpMessageConverter) {
        super(httpCryptoSm2Certificate);
        this.stringHttpMessageConverter = stringHttpMessageConverter;
    }

    @Override
    public boolean support(HttpInputMessage inputMessage) {
        ServletServerHttpRequest httpRequest;
        if (inputMessage instanceof ServletServerHttpRequest && (httpRequest = (ServletServerHttpRequest)inputMessage) != null && httpRequest.getHeaders().getContentType() != null) {
            return httpRequest.getMethod().matches(HttpMethod.POST.name()) && httpRequest.getHeaders().getContentType().includes(CryptoMediaType.APPLICATION_SM4_PUBLIC_JSON_UTF8);
        }
        return false;
    }

    @Override
    public CryptoHttpInputMessage doDecrypt(HttpInputMessage inputMessage) throws IOException {
        CryptoHttpInputMessage cryptoHttpInputMessage = null;
        cryptoHttpInputMessage = super.support(inputMessage) ? super.doDecrypt(inputMessage) : new CryptoHttpInputMessage();
        String encryptedData = (String)this.stringHttpMessageConverter.read(String.class, inputMessage);
        Map body = (Map)JSONObject.parseObject((String)encryptedData, Map.class);
        if (encryptedData != null) {
            String text = this.decryptData((String)body.get("data"));
            byte[] bytes = text.getBytes(this.getCharset(inputMessage));
            cryptoHttpInputMessage.setBody(bytes);
        }
        return cryptoHttpInputMessage;
    }
}

