/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport.support;

import cn.aotcloud.security.transport.AbstractResponseEncryptor;
import cn.aotcloud.security.transport.CryptoHttpInputMessage;
import cn.aotcloud.security.transport.HttpCryptoSm2Certificate;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.StreamUtils;

public class DefaultResponseEncryptor
extends AbstractResponseEncryptor {
    private Charset charset = Charset.forName("UTF-8");

    public DefaultResponseEncryptor(HttpCryptoSm2Certificate sm2Key) {
        super(sm2Key);
    }

    @Override
    public InputStream encrypt(InputStream inputStream) throws IOException {
        String encryptedText = this.encryptToText(inputStream);
        return new ByteArrayInputStream(encryptedText.getBytes(this.charset));
    }

    @Override
    public String encryptToText(InputStream inputStream) throws IOException {
        String body = StreamUtils.copyToString((InputStream)inputStream, (Charset)this.charset);
        return this.getTextEncryptor().encrypt(body);
    }

    @Override
    public HttpInputMessage encrypt(HttpInputMessage inputMessage) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        HttpServletUtil.putAllHeader((HttpHeaders)headers, (HttpHeaders)inputMessage.getHeaders());
        HttpServletUtil.setHeader((HttpHeaders)headers, (String)"Content-Type", (String)"application/x-ac-sm4-public-json;charset=UTF-8");
        return new CryptoHttpInputMessage(this.encrypt(inputMessage.getBody()), headers);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

