/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.transport.http;

import cn.aotcloud.security.transport.CryptoHttpInputMessage;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;

public class CryptoRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private final CryptoHttpInputMessage cryptoHttpInputMessage;
    private final HttpServletRequest request;

    public CryptoRequestWrapper(HttpServletRequest request, CryptoHttpInputMessage cryptoHttpInputMessage) {
        super(request);
        this.request = request;
        this.cryptoHttpInputMessage = cryptoHttpInputMessage;
        MultiValueMap<String, String> queryParams = cryptoHttpInputMessage.getQueryParams();
        this.parameterMap = HttpServletUtil.transferQueryParams(queryParams);
    }

    public String getQueryString() {
        return this.cryptoHttpInputMessage.getQueryString();
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> vector = new Vector<String>(this.parameterMap.keySet());
        return vector.elements();
    }

    public String getParameter(String name) {
        Object[] results = this.parameterMap.get(name);
        return ArrayUtils.isEmpty((Object[])results) ? "" : results[0];
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (HttpMethod.GET.name().equals(this.request.getMethod())) {
            return super.getInputStream();
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(CryptoRequestWrapper.read(this.cryptoHttpInputMessage.getBody()));
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    public String getContentType() {
        return "application/json";
    }

    public String getHeader(String name) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            return "application/json";
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (null != name && name.equalsIgnoreCase("Content-Type")) {
            return new Enumeration<String>(){
                private boolean hasGetted = false;

                @Override
                public boolean hasMoreElements() {
                    return !this.hasGetted;
                }

                @Override
                public String nextElement() {
                    if (this.hasGetted) {
                        throw new NoSuchElementException();
                    }
                    this.hasGetted = true;
                    return "application/json";
                }
            };
        }
        return super.getHeaders(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] read(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int num = inputStream.read(buffer);
            while (num != -1) {
                baos.write(buffer, 0, num);
                num = inputStream.read(buffer);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

