/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.tamperproofing.utils;

import cn.aotcloud.security.tamperproofing.utils.SafeHttpRequestWrapper;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ServletUtils {
    public static HttpServletRequest convertRequest(ServletRequest req) {
        return (HttpServletRequest)req;
    }

    public static SafeHttpRequestWrapper getSafeRequest(ServletRequest req) throws IOException {
        if (req instanceof SafeHttpRequestWrapper) {
            return (SafeHttpRequestWrapper)req;
        }
        return new SafeHttpRequestWrapper((HttpServletRequest)req);
    }

    public static HttpServletResponse convertResponse(ServletResponse res) {
        return (HttpServletResponse)res;
    }

    public static boolean isXwwwFormUrlencoded(HttpServletRequest request) {
        String contentType = HttpServletUtil.getHeader((HttpServletRequest)request, (String)"Content-Type");
        return StringUtils.indexOf((CharSequence)StringUtils.lowerCase((String)contentType), (CharSequence)"application/x-www-form-urlencoded") != -1;
    }

    public static boolean isApplicationJson(HttpServletRequest request) {
        String contentType = HttpServletUtil.getHeader((HttpServletRequest)request, (String)"Content-Type");
        return StringUtils.indexOf((CharSequence)StringUtils.lowerCase((String)contentType), (CharSequence)"application/json") != -1;
    }

    public static boolean isTextPlain(HttpServletRequest request) {
        String contentType = HttpServletUtil.getHeader((HttpServletRequest)request, (String)"Content-Type");
        return StringUtils.indexOf((CharSequence)StringUtils.lowerCase((String)contentType), (CharSequence)"text/plain") != -1;
    }

    public static boolean isMultipartFormData(HttpServletRequest request) {
        String contentType = HttpServletUtil.getHeader((HttpServletRequest)request, (String)"Content-Type");
        return StringUtils.indexOf((CharSequence)StringUtils.lowerCase((String)contentType), (CharSequence)"multipart/form-data") != -1;
    }

    public static Charset readCharacterEncoding(HttpServletRequest request) {
        Charset charset = null;
        String characterEncoding = HttpServletUtil.getCharacterEncoding((HttpServletRequest)request);
        charset = StringUtils.isNotBlank((CharSequence)characterEncoding) && !StringUtils.equalsIgnoreCase((CharSequence)characterEncoding, (CharSequence)"null") ? Charset.forName(characterEncoding) : Charset.defaultCharset();
        return charset;
    }
}

