/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.tamperproofing;

import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.security.tamperproofing.SafeException;
import cn.aotcloud.security.tamperproofing.TamperProofingChecker;
import cn.aotcloud.utils.HttpRequestUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public abstract class AbstractTamperProofingChecker
implements TamperProofingChecker {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());
    protected final TextEncryptor textEncryptor;

    public AbstractTamperProofingChecker(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    protected void doValdiate(HttpServletRequest request, String str, String sign) {
        if (StringUtils.isBlank((CharSequence)sign)) {
            throw new SafeException(request.getRequestURI() + "\uff0c\u6d88\u606f\u6458\u8981\u4e3a\u7a7a\uff01");
        }
        String encryptedData = this.textEncryptor.encrypt(str);
        if (!StringUtils.equalsIgnoreCase((CharSequence)encryptedData, (CharSequence)sign)) {
            throw new SafeException(request.getRequestURI() + "\uff0c\u9632\u7be1\u6539\u5f02\u5e38\uff1a\u975e\u6cd5\u53c2\u6570\uff01");
        }
    }

    protected String getSignValue(HttpServletRequest request) {
        String sign = HttpRequestUtil.getHeaderValue((HttpServletRequest)request, (String)"X-Ac-Data-Sign");
        if (StringUtils.isBlank((CharSequence)sign)) {
            sign = HttpRequestUtil.getParameterValue((HttpServletRequest)request, (String)"X-Ac-Data-Sign");
        }
        return sign;
    }
}

