package cn.aotcloud.safe.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 解码
 * 
 */
public class EscapeUtil {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(EscapeUtil.class);

	public static String decoderURL(String url, String enc) {

		String preUrl = null;
		String decodeUrl = null;

		try {
			if (StringUtils.isBlank(url)) {
				return url;
			}
			if (StringUtils.isBlank(enc)) {
				enc = "utf-8";
			}
			preUrl = url;
			decodeUrl = URLDecoder.decode(url, enc);
			while (!StringUtils.equals(preUrl, decodeUrl)) {
				preUrl = decodeUrl;
				decodeUrl = URLDecoder.decode(decodeUrl, enc);

			}
			return decodeUrl;
		} catch (UnsupportedEncodingException e) {
			LOGGER.debug("url解码异常：" + e.getMessage());
			return url;
		}
	}

	public static String unescape(String value, String enc) {
		if (StringUtils.isBlank(value)) {
			return value;
		}
		value = decoderURL(value, enc);
		// value = StringEscapeUtils.unescapeHtml(value);
		// value = StringEscapeUtils.unescapeJava(value);
		// value = StringEscapeUtils.unescapeJavaScript(value);
		// value = StringEscapeUtils.unescapeXml(value);
		return value;
	}

	public static String[] unescape(String[] value, String enc) {
		if (value == null || value.length <= 0) {
			return value;
		}
		for (int i = 0; i < value.length; i++) {
			if (StringUtils.isBlank(value[i])) {
				continue;
			}
			value[i] = unescape(value[i], enc);
		}
		return value;
	}
	
	public static String toURLRegExp(String word) {
		if(StringUtils.isBlank(word)) {
			return word;
		} else {
			String newWord = "((^\\s*)|(\\S+\\s+))";
			for(int i=0; i<word.length(); i++) {
				String ch = StringUtils.substring(word, i, i+1);
				String ch_hex = Integer.toHexString(ch.charAt(0));
				String ch_uc_hex = Integer.toHexString(ch.toUpperCase().charAt(0));
				String ch_new = "(%"+ch_hex+")|"+ch+"|(%"+ch_uc_hex+")";
				if(i<word.length()-1) {
					newWord = newWord + "("+ch_new +"|"+ch_new.toUpperCase()+")(\\s)*";
				} else {
					newWord = newWord + "("+ch_new +"|"+ch_new.toUpperCase()+")((\\s+\\S+)|(\\s*$))";
				}
			}
			return newWord;
		}
	}
	
	public static String wordToURLRegExp(String word) {
		if(StringUtils.isBlank(word)) {
			return word;
		} else {
			String newWord = "";
			for(int i=0; i<word.length(); i++) {
				Set<String> set = new HashSet<String>();
				String ch = StringUtils.substring(word, i, i+1);
				String ch_uc = ch.toUpperCase();
				//String ch_hex = Integer.toHexString(ch.charAt(0));
				//String ch_uc_hex = Integer.toHexString(ch_uc.charAt(0));
				set.add(ch);
				set.add(ch_uc);
				//set.add("(%"+ch_hex+")");
				//set.add("(%"+ch_uc_hex+")");
				//set.add("(%"+ch_hex.toUpperCase()+")");
				//set.add("(%"+ch_uc_hex.toUpperCase()+")");
				String ch_new = StringUtils.join(set,"|");
				newWord = newWord + "("+ch_new+")(\\s)*";
			}
			return newWord + "";
		}
	}
	
	public static String charToURLRegExp(String word) {
		if(StringUtils.isBlank(word)) {
			return word;
		} else {
			String newWord = "(\\s)*";
			for(int i=0; i<word.length(); i++) {
				Set<String> set = new HashSet<String>();
				String ch = StringUtils.substring(word, i, i+1);
				String ch_uc = ch.toUpperCase();
				//String ch_hex = Integer.toHexString(ch.charAt(0));
				//String ch_uc_hex = Integer.toHexString(ch_uc.charAt(0));
				set.add(ch);
				set.add(ch_uc);
				//set.add("(%"+ch_hex+")");
				//set.add("(%"+ch_uc_hex+")");
				//set.add("(%"+ch_hex.toUpperCase()+")");
				//set.add("(%"+ch_uc_hex.toUpperCase()+")");
				String ch_new = StringUtils.join(set,"|");
				newWord = newWord + "("+ch_new+")(\\s)*";
			}
			return newWord + "";
		}
	}
	
	public static void main(String[] args) throws UnsupportedEncodingException {
//		String arg1 = "( \\s|\\S)*(exec(\\s|\\+)+(s|x)p\\w+)(\\s|\\S)*"; //Exec Commond
//		String arg2 = "( \\s|\\S)*((%3C)|<)((%2F)|/)*[a-z0-9%]+((%3E)|>)(\\s|\\S)*"; //Simple XSS
//		String arg3 = "( \\s|\\S)*((%65)|e)(\\s)*((%76)|v)(\\s)*((%61)|a)(\\s)*((%6C)|l)(\\s|\\S)*"; //Eval XSS
//		String arg4 = "( \\s|\\S)*((%3C)|<)((%69)|i|I|(%49))((%6D)|m|M|(%4D))((%67)|g|G|(%47))[^\\n]+((%3E)|>)(\\s|\\S)*"; //Image XSS
//		String arg5 = "( \\s|\\S)*((%73)|s)(\\s)*((%63)|c)(\\s)*((%72)|r)(\\s)*((%69)|i)(\\s)*((%70)|p)(\\s)*((%74)|t)(\\s|\\S)*"; //Script XSS
//		String arg6 = "( \\s|\\S)*((%27)|(')|(%3D)|(=)|(/)|(%2F)|(\")|((%22)|(-|%2D){2})|(%23)|(%3B)|(;))+(\\s|\\S)*"; //SQL Injection
		//System.out.println(URLDecoder.decode(arg5, "UTF-8"));
		
//		String str = "script";
//		String test= "<script  >%54 eww";
//		String str_new = toURLRegExp1(str);
//		System.out.println(str_new);
//		boolean flag = Pattern.matches("(.*?)</{0,1}(s|S|(%73)|(%53))(\\s)*(c|C|(%43)|(%63))(\\s)*(r|R|(%72)|(%52))(\\s)*((%49)|i|I|(%69))(\\s)*(p|P|(%50)|(%70))(\\s)*(t|T|(%54)|(%74))(\\s)*>(.*?)", test);
//		System.out.println(flag);
//		
//		Pattern pattern = Pattern.compile(str_new);
//		Matcher matcher = pattern.matcher(test);
//		while(matcher.find()) {
//			 System.out.println(matcher.group(0));
//		}
		
		List<String> wordList = Arrays.asList(new String[] {
				"script",
				"javascript",
				"eval",
				"expression",
				"vbscript",
				"onload",
				"src",
				"img",
				"style",
				"function",
				"window",
				"document",
		});
		wordList.forEach(item->{
			System.out.println("xssWord.put(\""+item+"\", \""+wordToURLRegExp(item)+"\");");
		});
		
		List<String> charList = Arrays.asList(new String[] {
				"<",
				"/",
				">",
				"(",
				")",
				"[",
				"]",
				".",
				":",
				"=",
				"\"",
				"\'"
		});
		charList.forEach(item->{
			System.out.println("xssChar.put(\""+item+"\", \""+charToURLRegExp(item)+"\");");
		});
		
		List<String> strList = Arrays.asList(new String[] {
				"< sc riP t text mm = 'ww'>alert(123);</script>",
				" < jav ascript ( alert(123);",
				" < src = \'ss",
				"xxx functi on ：",
				" window .  xas",
				" docu men t(  zxcs",
				"<s Cri Pt>alert(123);</Script>"
		});
		
		strList.forEach(str-> {
			System.out.println(matchesXss(str) + " --> " + str);
		});
	}
	
	public static boolean matchesXss(String str) {
		Map<String,String> xssWord = new HashMap<String,String>();
		xssWord.put("script", "(s|S)(\\s)*(c|C)(\\s)*(r|R)(\\s)*(i|I)(\\s)*(p|P)(\\s)*(t|T)(\\s)*");
		xssWord.put("javascript", "(j|J)(\\s)*(a|A)(\\s)*(v|V)(\\s)*(a|A)(\\s)*(s|S)(\\s)*(c|C)(\\s)*(r|R)(\\s)*(i|I)(\\s)*(p|P)(\\s)*(t|T)(\\s)*");
		xssWord.put("eval", "(e|E)(\\s)*(v|V)(\\s)*(a|A)(\\s)*(l|L)(\\s)*");
		xssWord.put("exec", "(e|E)(\\s)*(x|X)(\\s)*(e|E)(\\s)*(c|C)(\\s)*");
		xssWord.put("expression", "(e|E)(\\s)*(x|X)(\\s)*(p|P)(\\s)*(r|R)(\\s)*(e|E)(\\s)*(s|S)(\\s)*(s|S)(\\s)*(i|I)(\\s)*(o|O)(\\s)*(n|N)(\\s)*");
		xssWord.put("vbscript", "(v|V)(\\s)*(b|B)(\\s)*(s|S)(\\s)*(c|C)(\\s)*(r|R)(\\s)*(i|I)(\\s)*(p|P)(\\s)*(t|T)(\\s)*");
		xssWord.put("onload", "(o|O)(\\s)*(n|N)(\\s)*(l|L)(\\s)*(o|O)(\\s)*(a|A)(\\s)*(d|D)(\\s)*");
		xssWord.put("src", "(s|S)(\\s)*(r|R)(\\s)*(c|C)(\\s)*");
		xssWord.put("img", "(i|I)(\\s)*(m|M)(\\s)*(g|G)(\\s)*");
		xssWord.put("style", "(s|S)(\\s)*(t|T)(\\s)*(y|Y)(\\s)*(l|L)(\\s)*(e|E)(\\s)*");
		xssWord.put("function", "(f|F)(\\s)*(u|U)(\\s)*(n|N)(\\s)*(c|C)(\\s)*(t|T)(\\s)*(i|I)(\\s)*(o|O)(\\s)*(n|N)(\\s)*");
		xssWord.put("window", "(w|W)(\\s)*(i|I)(\\s)*(n|N)(\\s)*(d|D)(\\s)*(o|O)(\\s)*(w|W)(\\s)*");
		xssWord.put("document", "(d|D)(\\s)*(o|O)(\\s)*(c|C)(\\s)*(u|U)(\\s)*(m|M)(\\s)*(e|E)(\\s)*(n|N)(\\s)*(t|T)(\\s)*");
		
		Map<String,String> xssChar = new HashMap<String,String>();
		xssChar.put("<", "(\\s)*(<)(\\s)*");
		xssChar.put("/", "(\\s)*(/)(\\s)*");
		xssChar.put(">", "(\\s)*(>)(\\s)*");
		xssChar.put("(", "(\\s)*(\\()(\\s)*");
		xssChar.put(")", "(\\s)*(\\))(\\s)*");
		xssChar.put("[", "(\\s)*([)(\\s)*");
		xssChar.put("]", "(\\s)*(])(\\s)*");
		xssChar.put(".", "(\\s)*(.)(\\s)*");
		xssChar.put(":", "(\\s)*(:)(\\s)*");
		xssChar.put("=", "(\\s)*(=)(\\s)*");
		xssChar.put("\"", "(\\s)*(\")(\\s)*");
		xssChar.put("\'", "(\\s)*(\')(\\s)*");
		
		ArrayList<String> xssRagex = new ArrayList<String>();
		// <style var=value> | </style var=value>
		xssRagex.add("(.*?)" + xssChar.get("<") + xssChar.get("/") + "{0,1}\\s*" + xssWord.get("style") + "(\\s+\\w*"+xssChar.get("=")+"\\w*\\s*)*" + xssChar.get(">") + "(.*?)");
		// <script var=value> | </script var=value>
		xssRagex.add("(.*?)" + xssChar.get("<") + xssChar.get("/") + "{0,1}\\s*" + xssWord.get("script") + "(\\s+\\w*"+xssChar.get("=")+"\\w*\\s*)*" + xssChar.get(">") + "(.*?)");
		// javascript:|(
		xssRagex.add("(.*?)" + xssWord.get("javascript") + "(" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// vbscript:|(
		xssRagex.add("(.*?)" + xssWord.get("vbscript") + "(" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// function:|(
		xssRagex.add("(.*?)" + xssWord.get("function") + "(" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// window.:|(
		xssRagex.add("(.*?)" + xssWord.get("window") + "(" + xssChar.get(".") + "|" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// document.:|(
		xssRagex.add("(.*?)" + xssWord.get("document") + "(" + xssChar.get(".") + "|" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// expression:|(
		xssRagex.add("(.*?)" + xssWord.get("expression") + "(" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// eval:|(
		xssRagex.add("(.*?)" + xssWord.get("eval") + "(" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// exec:|(
		xssRagex.add("(.*?)" + xssWord.get("exec") + "(" + xssChar.get(":") + "|" + xssChar.get("(") + ")*(.*?)");
		// src[\\S\\s]*=[\\S\\s]*
		xssRagex.add("(.*?)" + xssWord.get("src") + "[\\S\\s]*" + xssChar.get("=") + "[\\S\\s]*(.*?)");
		// img[\\S\\s]+src[\\S\\s]*=[\\S\\s]*
		xssRagex.add("(.*?)" + xssChar.get("<") +  xssWord.get("img") + "[\\S\\s]+" + xssWord.get("src") + "[\\S\\s]*" + xssChar.get("=") + "[\\S\\s]*(.*?)");
				
		boolean matches = false;
		for(String ragex : xssRagex) {
			Pattern scriptPattern = Pattern.compile(ragex, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
			if(scriptPattern.matcher(str).find()) {
				matches = true;
				break;
			}
		}
		return matches;
	}
}
