package cn.aotcloud.safe.util;

import org.apache.commons.lang3.StringUtils;

public class NumberUtils {

	public static Long getLongExpression(String longExpression, Long defaultValue) {
		if (StringUtils.isNotBlank(longExpression)) {
			if (longExpression.toUpperCase().endsWith("B")) {
				longExpression = StringUtils.substring(longExpression, 0, longExpression.length() - 1);
			}
			String[] numbers = longExpression.split("\\*");
			long sum = 1;
			for (int i = 0; i < numbers.length - 1; i++) {
				sum = sum * Long.parseLong(numbers[i].trim());
			}
			String lastStr = numbers[numbers.length - 1].toUpperCase().trim();
			String lastNum = StringUtils.substring(lastStr, 0, lastStr.length() - 1).trim();
			if (lastStr.endsWith("K")) {
				sum = sum * Long.parseLong(lastNum) * 1024;
			} else if (lastStr.endsWith("M")) {
				sum = sum * Long.parseLong(lastNum) * 1024 * 1024;
			} else if (lastStr.endsWith("G")) {
				sum = sum * Long.parseLong(lastNum) * 1024 * 1024 * 1024;
			} else if (StringUtils.isNumeric(lastStr)) {
				sum = sum * Long.parseLong(lastStr);
			} else {
				sum = defaultValue;
			}

			return sum;
		}

		return defaultValue;
	}
}
