/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.autoconfigure.jdbc;

import cn.aotcloud.safe.autoconfigure.SafeProperties;
import cn.aotcloud.safe.autoconfigure.jdbc.AbstractBinderUtil;
import cn.aotcloud.safe.autoconfigure.jdbc.SafeConfigItemEntry;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;

public class BinderUtil
extends AbstractBinderUtil {
    public void rebindSafeConfigRequestToBean(HttpServletRequest request, SafeProperties safeProperties) {
        this.LOGGER.info(String.format("\u6267\u884c\u6765\u81earequest\u7684\u5bf9\u8c61\u7ed1\u5b9a\uff1a%s", safeProperties.getClass().getName()));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            String envKey = AbstractBinderUtil.SAFE_PROP_PREFIX + name;
            dataMap.put(envKey, value);
        }
        MapConfigurationPropertySource sources = new MapConfigurationPropertySource(dataMap);
        Binder binder = new Binder(new ConfigurationPropertySource[]{sources});
        binder.bind("acloud.safe", Bindable.ofInstance(safeProperties.getClass())).get();
    }

    public void rebindSafeConfigEntrysToBean(List<SafeConfigItemEntry> entryList, SafeProperties safeProperties) {
        HashMap dataMap = new HashMap();
        this.LOGGER.info(String.format("\u6267\u884c\u6765\u81ea\u6570\u636e\u5e93\u7684\u5bf9\u8c61\u7ed1\u5b9a\uff1a%s", safeProperties.getClass().getName()));
        entryList.forEach(entry -> {
            String envKey = AbstractBinderUtil.SAFE_PROP_PREFIX + entry.getPropKey();
            dataMap.put(envKey, entry.getPropValue());
        });
        MapConfigurationPropertySource sources = new MapConfigurationPropertySource(dataMap);
        Binder binder = new Binder(new ConfigurationPropertySource[]{sources});
        binder.bind("acloud.safe", Bindable.ofInstance((Object)safeProperties)).get();
    }

    public void resetMultipartConfigElement(MultipartConfigElement multipartConfigElement, SafeProperties safeProperties) {
        try {
            Field maxFileSizeField = multipartConfigElement.getClass().getDeclaredField("maxFileSize");
            maxFileSizeField.setAccessible(true);
            maxFileSizeField.setLong(multipartConfigElement, safeProperties.getUpload().getMaxFileByteSize());
            Field maxRequestSizeField = multipartConfigElement.getClass().getDeclaredField("maxRequestSize");
            maxRequestSizeField.setAccessible(true);
            maxRequestSizeField.setLong(multipartConfigElement, safeProperties.getUpload().getMaxRequestByteSize());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

