/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.kafka.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public final class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BeanUtils.class);

    public static Method[] getMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    public static Method getMethodByAnnotation(Method[] methods, Class<? extends Annotation> annotation) {
        if (methods == null) {
            return null;
        }
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation((Method)method, annotation) == null) continue;
            return method;
        }
        return null;
    }

    public static boolean invokeMethod(Object target, Method method) {
        return BeanUtils.invokeMethod(target, method, new Object[0]);
    }

    public static boolean invokeMethod(Object target, Method method, Object ... args) {
        block4: {
            try {
                method.invoke(target, args);
                return true;
            }
            catch (IllegalAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("IllegalAccessException", (Throwable)e);
                }
            }
            catch (InvocationTargetException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("InvocationTargetException", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean validParameterTypes(Method method, int length, Class<?> ... array) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return length == parameterTypes.length;
    }
}

