/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.kafka.spring;

import cn.antcore.kafka.annotation.KafkaClient;
import cn.antcore.kafka.builder.KafkaBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SpringKafka
implements ApplicationContextAware,
InitializingBean {
    private ConfigurableApplicationContext context;
    private ConfigurableListableBeanFactory beanFactory;

    public void afterPropertiesSet() {
        this.init();
    }

    public void init() {
        this.beanFactory = this.context.getBeanFactory();
        this.scanKafkaClient();
    }

    private void scanKafkaClient() {
        String[] names = this.beanFactory.getBeanNamesForAnnotation(KafkaClient.class);
        KafkaBuilder.createClient(this.beanFactory, names);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
    }
}

